/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.server.ServerCommandLineArgs;

public class ServerCommandLineArgsTest {
    @Test
    public void shouldPickUpSpecifiedConfigFile() throws Exception {
        File dir = new File("/some-dir").getAbsoluteFile();
        Optional<File> expectedFile = Optional.of(new File(dir, "neo4j.conf"));
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir", dir.toString()).configFile());
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir=" + dir).configFile());
    }

    @Test
    public void shouldResolveConfigFileRelativeToWorkingDirectory() throws Exception {
        Optional<File> expectedFile = Optional.of(new File("some-dir", "neo4j.conf"));
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir", "some-dir").configFile());
        Assert.assertEquals(expectedFile, (Object)this.parse("--config-dir=some-dir").configFile());
    }

    @Test
    public void shouldReturnNullIfConfigDirIsNotSpecified() {
        Assert.assertEquals(Optional.empty(), (Object)this.parse(new String[0]).configFile());
    }

    @Test
    public void shouldPickUpSpecifiedHomeDir() throws Exception {
        File homeDir = new File("/some/absolute/homedir").getAbsoluteFile();
        Assert.assertEquals((Object)homeDir, (Object)this.parse("--home-dir", homeDir.toString()).homeDir());
        Assert.assertEquals((Object)homeDir, (Object)this.parse("--home-dir=" + homeDir.toString()).homeDir());
    }

    @Test
    public void shouldReturnNullIfHomeDirIsNotSpecified() {
        Assert.assertNull((Object)this.parse(new String[0]).homeDir());
    }

    @Test
    public void shouldPickUpOverriddenConfigurationParameters() throws Exception {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoption=myvalue"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Pair[]{Pair.of((Object)"myoption", (Object)"myvalue")}), (Object)Iterators.asSet((Object[])parsed.configOverrides()));
    }

    @Test
    public void shouldPickUpOverriddenBooleanConfigurationParameters() throws Exception {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoptionenabled"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Pair[]{Pair.of((Object)"myoptionenabled", (Object)Boolean.TRUE.toString())}), (Object)Iterators.asSet((Object[])parsed.configOverrides()));
    }

    @Test
    public void shouldPickUpMultipleOverriddenConfigurationParameters() throws Exception {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "my_first_option=first", "-c", "myoptionenabled", "-c", "my_second_option=second"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Pair[]{Pair.of((Object)"my_first_option", (Object)"first"), Pair.of((Object)"myoptionenabled", (Object)Boolean.TRUE.toString()), Pair.of((Object)"my_second_option", (Object)"second")}), (Object)Iterators.asSet((Object[])parsed.configOverrides()));
    }

    private ServerCommandLineArgs parse(String ... args) {
        return ServerCommandLineArgs.parse((String[])args);
    }
}

