/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpResponseContext;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.rest.repr.RepresentationWriteHandler;

public class CommitOnSuccessfulStatusCodeRepresentationWriteHandler
implements RepresentationWriteHandler {
    private final HttpContext httpContext;
    private Transaction transaction;

    public CommitOnSuccessfulStatusCodeRepresentationWriteHandler(HttpContext httpContext, Transaction transaction) {
        this.httpContext = httpContext;
        this.transaction = transaction;
    }

    @Override
    public void onRepresentationStartWriting() {
    }

    @Override
    public void onRepresentationWritten() {
        HttpResponseContext response = this.httpContext.getResponse();
        int statusCode = response.getStatus();
        if (statusCode >= 200 && statusCode < 300) {
            this.transaction.success();
        }
    }

    @Override
    public void onRepresentationFinal() {
        this.closeTransaction();
    }

    public void closeTransaction() {
        this.transaction.close();
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }
}

