/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.operator.OperatorCreationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.configuration.ssl.LegacySslPolicyConfig;
import org.neo4j.ssl.PkiUtils;

public class CertificatesIT {
    private static File keyFile;
    private static File certFile;
    private static PkiUtils certFactory;
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> {
        settings.put(LegacySslPolicyConfig.tls_certificate_file.name(), certFile.getAbsolutePath());
        settings.put(LegacySslPolicyConfig.tls_key_file.name(), keyFile.getAbsolutePath());
    });

    @Test
    public void shouldUseConfiguredCertificate() throws Exception {
        SecureSocketConnection connection = new SecureSocketConnection();
        connection.connect(new HostnamePort("localhost:7687")).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L));
        Set certificatesSeen = connection.getServerCertificatesSeen();
        MatcherAssert.assertThat((Object)certificatesSeen, (Matcher)Matchers.contains((Object[])new X509Certificate[]{this.loadCertificateFromDisk()}));
    }

    private X509Certificate loadCertificateFromDisk() throws CertificateException, IOException {
        X509Certificate[] certificates = certFactory.loadCertificates(certFile);
        MatcherAssert.assertThat((Object)certificates.length, (Matcher)CoreMatchers.equalTo((Object)1));
        return certificates[0];
    }

    @BeforeClass
    public static void setUp() throws IOException, GeneralSecurityException, OperatorCreationException {
        certFactory = new PkiUtils();
        keyFile = File.createTempFile("key", "pem");
        certFile = File.createTempFile("key", "pem");
        keyFile.deleteOnExit();
        certFile.deleteOnExit();
        keyFile.delete();
        certFile.delete();
        certFactory.createSelfSignedCertificate(certFile, keyFile, "my.domain");
    }
}

