/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.scripting.javascript.GlobalJavascriptInitializer;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class ServerConfigIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldPickUpAddressFromConfig() throws Exception {
        ListenSocketAddress nonDefaultAddress = new ListenSocketAddress("0.0.0.0", 4321);
        this.server = CommunityServerBuilder.server().onAddress(nonDefaultAddress).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertEquals((Object)nonDefaultAddress, (Object)this.server.getAddress());
        JaxRsResponse response = new RestRequest(this.server.baseUri()).get();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        response.close();
    }

    @Test
    public void shouldPickupRelativeUrisForMangementApiAndRestApi() throws IOException {
        String dataUri = "/a/different/data/uri/";
        String managementUri = "/a/different/management/uri/";
        this.server = CommunityServerBuilder.server().withRelativeRestApiUriPath(dataUri).usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).withRelativeManagementApiUriPath(managementUri).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474" + dataUri, MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = new RestRequest().get("http://localhost:7474" + managementUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldGenerateWADLWhenExplicitlyEnabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.wadl_enabled.name(), "true").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/vnd.sun.wadl+xml", ((List)response.getHeaders().get((Object)"Content-Type")).iterator().next());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)"<application xmlns=\"http://wadl.dev.java.net/2009/02\">"));
    }

    @Test
    public void shouldNotGenerateWADLWhenNotExplicitlyEnabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.server().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldNotGenerateWADLWhenExplicitlyDisabledInConfig() throws IOException {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.wadl_enabled.name(), "false").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        JaxRsResponse response = new RestRequest().get("http://localhost:7474/application.wadl", MediaType.WILDCARD_TYPE);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldEnablConsoleServiceByDefault() throws IOException {
        this.server = CommunityServerBuilder.server().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertEquals((long)200L, (long)new RestRequest().get("http://localhost:7474/db/manage/server/console").getStatus());
    }

    @Test
    public void shouldDisableConsoleServiceWhenAskedTo() throws IOException {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.console_module_enabled.name(), "false").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertEquals((long)404L, (long)new RestRequest().get("http://localhost:7474/db/manage/server/console").getStatus());
    }

    @Test
    public void shouldHaveSandboxingEnabledByDefault() throws Exception {
        this.server = CommunityServerBuilder.server().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        String node = HTTP.POST(this.server.baseUri().toASCIIString() + "db/data/node").location();
        JaxRsResponse response = new RestRequest().post(node + "/traverse/node", "{\n  \"order\" : \"breadth_first\",\n  \"return_filter\" : {\n    \"body\" : \"position.getClass().getClassLoader()\",\n    \"language\" : \"javascript\"\n  },\n  \"prune_evaluator\" : {\n    \"body\" : \"position.getClass().getClassLoader()\",\n    \"language\" : \"javascript\"\n  },\n  \"uniqueness\" : \"node_global\",\n  \"relationships\" : [ {\n    \"direction\" : \"all\",\n    \"type\" : \"knows\"\n  }, {\n    \"direction\" : \"all\",\n    \"type\" : \"loves\"\n  } ],\n  \"max_depth\" : 3\n}", MediaType.APPLICATION_JSON_TYPE);
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test(expected=RuntimeException.class)
    public void shouldBeAbleToDisableSandboxing() throws Exception {
        GlobalJavascriptInitializer.initialize((GlobalJavascriptInitializer.Mode)GlobalJavascriptInitializer.Mode.SANDBOXED);
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.script_sandboxing_enabled.name(), "false").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
    }
}

