/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;

public class ConfigFileBuilder {
    private final File directory;
    private final Map<String, String> config;

    public static ConfigFileBuilder builder(File directory) {
        return new ConfigFileBuilder(directory);
    }

    private ConfigFileBuilder(File directory) {
        this.directory = directory;
        this.config = MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.data_directory.name(), directory.getAbsolutePath() + "/data", ServerSettings.management_api_path.name(), "http://localhost:7474/db/manage/", ServerSettings.rest_api_path.name(), "http://localhost:7474/db/data/"});
    }

    public Optional<File> build() throws IOException {
        File file = new File(this.directory, "config");
        ServerTestUtils.writeConfigToFile(this.config, file);
        return Optional.of(file);
    }

    public ConfigFileBuilder withNameValue(String name, String value) {
        this.config.put(name, value);
        return this;
    }

    public ConfigFileBuilder withSetting(Setting setting, String value) {
        this.config.put(setting.name(), value);
        return this;
    }

    public ConfigFileBuilder withoutSetting(Setting setting) {
        this.config.remove(setting.name());
        return this;
    }
}

