/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;

public class DegreeIT
extends AbstractRestFunctionalTestBase {
    @Documented(value="Get the degree of a node\n\nReturn the total number of relationships associated with a node.")
    @Test
    @GraphDescription.Graph(value={"Root knows Mattias", "Root knows Johan"})
    public void get_degree() throws JsonParseException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Root"));
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(nodeUri + "/degree/all");
        TestCase.assertEquals((int)2, (int)JsonHelper.jsonNode((String)response.response().getEntity()).asInt());
    }

    @Documented(value="Get the degree of a node by direction\n\nReturn the number of relationships of a particular direction for a node.\nSpecify `all`, `in` or `out`.")
    @Test
    @GraphDescription.Graph(value={"Root knows Mattias", "Root knows Johan"})
    public void get_degree_by_direction() throws JsonParseException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Root"));
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(nodeUri + "/degree/out");
        TestCase.assertEquals((int)2, (int)JsonHelper.jsonNode((String)response.response().getEntity()).asInt());
    }

    @Documented(value="Get the degree of a node by direction and types\n\nIf you are only interested in the degree of a particular relationship type, or a set of relationship types, you specify relationship types after the direction.\nYou can combine multiple relationship types by using the `&` character.")
    @Test
    @GraphDescription.Graph(value={"Root KNOWS Mattias", "Root KNOWS Johan", "Root LIKES Cookie"})
    public void get_degree_by_direction_and_type() throws JsonParseException {
        Map nodes = (Map)this.data.get();
        String nodeUri = this.getNodeUri((Node)nodes.get("Root"));
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(nodeUri + "/degree/out/KNOWS&LIKES");
        TestCase.assertEquals((int)3, (int)JsonHelper.jsonNode((String)response.response().getEntity()).asInt());
    }
}

