/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.security.UserManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.rest.dbms.DelegatingPrincipal;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.BasicSecurityContext;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.test.server.EntityOutputFormat;

public class UserServiceTest {
    protected static final User NEO4J_USER = new User.Builder("neo4j", Credential.forPassword((String)"neo4j")).withRequiredPasswordChange(true).build();
    protected final PasswordPolicy passwordPolicy = new BasicPasswordPolicy();
    protected final UserRepository userRepository = new InMemoryUserRepository();
    protected UserManagerSupplier userManagerSupplier;
    protected SecurityContext neo4jContext;
    protected Principal neo4jPrinciple;

    protected void setupAuthManagerAndSubject() {
        BasicAuthManager basicAuthManager = new BasicAuthManager(this.userRepository, this.passwordPolicy, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class), (UserRepository)new InMemoryUserRepository());
        this.userManagerSupplier = basicAuthManager;
        this.neo4jContext = new BasicSecurityContext(basicAuthManager, NEO4J_USER, AuthenticationResult.SUCCESS);
    }

    @Before
    public void setUp() throws InvalidArgumentsException, IOException {
        this.userRepository.create(NEO4J_USER);
        this.setupAuthManagerAndSubject();
        this.neo4jPrinciple = new DelegatingPrincipal("neo4j", this.neo4jContext);
    }

    @After
    public void tearDown() throws InvalidArgumentsException, IOException {
        this.userRepository.delete(NEO4J_USER);
    }

    @Test
    public void shouldReturnValidUserRepresentation() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"username\" : \"neo4j\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"password_change\" : \"http://www.example.com/user/neo4j/password\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"password_change_required\" : true"));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfNotAuthenticated() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn(null);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfDifferentUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((UserManagerSupplier)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("fred", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenRequestingUserIfUnknownUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        this.userManagerSupplier.getUserManager().deleteUser("neo4j");
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.getUser("neo4j", req);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldChangePasswordAndReturnSuccess() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        this.userManagerSupplier.getUserManager().getUser("neo4j").credentials().matchesPassword("test");
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfNotAuthenticated() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn(null);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((UserManagerSupplier)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void shouldReturn404WhenChangingPasswordIfDifferentUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("fred", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
        Mockito.verifyZeroInteractions((Object[])new Object[]{userManager});
    }

    @Test
    public void shouldReturn422WhenChangingPasswordIfUnknownUser() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        this.userRepository.delete(NEO4J_USER);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"test\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
    }

    @Test
    public void shouldReturn400IfPayloadIsInvalid() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((UserManagerSupplier)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "xxx");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
    }

    @Test
    public void shouldReturn422IfMissingPassword() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((UserManagerSupplier)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"unknown\" : \"unknown\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Required parameter 'password' is missing.\""));
    }

    @Test
    public void shouldReturn422IfInvalidPasswordType() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService((UserManagerSupplier)Mockito.mock(BasicAuthManager.class), (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : 1 }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Expected 'password' to be a string.\""));
    }

    @Test
    public void shouldReturn422IfEmptyPassword() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.General.InvalidArguments\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"A password cannot be empty.\""));
    }

    @Test
    public void shouldReturn422IfPasswordIdentical() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getUserPrincipal()).thenReturn((Object)this.neo4jPrinciple);
        EntityOutputFormat outputFormat = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://www.example.com"), null);
        UserService userService = new UserService(this.userManagerSupplier, (InputFormat)new JsonFormat(), (OutputFormat)outputFormat);
        Response response = userService.setPassword("neo4j", req, "{ \"password\" : \"neo4j\" }");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)422));
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.General.InvalidArguments\""));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"\"message\" : \"Old password and new password cannot be the same.\""));
    }
}

