/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.GraphExtractionWriter;
import org.neo4j.server.rest.transactional.MapRow;
import org.neo4j.server.rest.transactional.TransactionStateChecker;
import org.neo4j.test.Property;
import org.neo4j.test.mockito.mock.GraphMock;
import org.neo4j.test.mockito.mock.Link;
import org.neo4j.test.mockito.mock.Properties;

public class GraphExtractionWriterTest {
    private final Node n1 = GraphMock.node((long)17L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"n1")}), (String[])new String[]{"Foo"});
    private final Node n2 = GraphMock.node((long)666L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"n2")}), (String[])new String[0]);
    private final Node n3 = GraphMock.node((long)42L, (Properties)Properties.properties((Property[])new Property[]{Property.property((String)"name", (Object)"n3")}), (String[])new String[]{"Foo", "Bar"});
    private final Relationship r1 = GraphMock.relationship((long)7L, (Node)this.n1, (String)"ONE", (Node)this.n2, (Property[])new Property[]{Property.property((String)"name", (Object)"r1")});
    private final Relationship r2 = GraphMock.relationship((long)8L, (Node)this.n1, (String)"TWO", (Node)this.n3, (Property[])new Property[]{Property.property((String)"name", (Object)"r2")});
    private final TransactionStateChecker checker = new TransactionStateChecker(id -> false, id -> false);
    private JsonFactory jsonFactory = new JsonFactory();

    @Test
    public void shouldExtractNodesFromRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("n1", this.n1);
        row.put("n2", this.n2);
        row.put("n3", this.n3);
        row.put("other.thing", "hello");
        row.put("some.junk", 39372);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        Assert.assertEquals((String)"there should be no relationships", (long)0L, (long)result.get("graph").get("relationships").size());
    }

    @Test
    public void shouldExtractRelationshipsFromRowAndNodesFromRelationships() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("r1", this.r1);
        row.put("r2", this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    public void shouldExtractPathFromRowAndExtractNodesAndRelationshipsFromPath() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("p", GraphMock.path((Node)this.n2, (Link[])new Link[]{Link.link((Relationship)this.r1, (Node)this.n1), Link.link((Relationship)this.r2, (Node)this.n3)}));
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    public void shouldExtractGraphFromMapInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap<String, Relationship> map = new HashMap<String, Relationship>();
        row.put("map", map);
        map.put("r1", this.r1);
        map.put("r2", this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    public void shouldExtractGraphFromListInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        ArrayList<Relationship> list = new ArrayList<Relationship>();
        row.put("list", list);
        list.add(this.r1);
        list.add(this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    public void shouldExtractGraphFromListInMapInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap map = new HashMap();
        ArrayList<Relationship> list = new ArrayList<Relationship>();
        map.put("list", list);
        row.put("map", map);
        list.add(this.r1);
        list.add(this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    @Test
    public void shouldExtractGraphFromMapInListInTheRow() throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        HashMap<String, Relationship> map = new HashMap<String, Relationship>();
        ArrayList<HashMap<String, Relationship>> list = new ArrayList<HashMap<String, Relationship>>();
        list.add(map);
        row.put("list", list);
        map.put("r1", this.r1);
        map.put("r2", this.r2);
        JsonNode result = this.write(row);
        this.assertNodes(result);
        this.assertRelationships(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode write(Map<String, Object> row) throws IOException, JsonParseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator json = this.jsonFactory.createJsonGenerator((OutputStream)out);
        json.writeStartObject();
        try {
            new GraphExtractionWriter().write(json, row.keySet(), (Result.ResultRow)new MapRow(row), this.checker);
        }
        finally {
            json.writeEndObject();
            json.flush();
        }
        return JsonHelper.jsonNode((String)out.toString(StandardCharsets.UTF_8.name()));
    }

    private void assertNodes(JsonNode result) {
        JsonNode nodes = result.get("graph").get("nodes");
        Assert.assertEquals((String)"there should be 3 nodes", (long)3L, (long)nodes.size());
        GraphExtractionWriterTest.assertNode("17", nodes, Arrays.asList("Foo"), Property.property((String)"name", (Object)"n1"));
        GraphExtractionWriterTest.assertNode("666", nodes, Arrays.asList(new String[0]), Property.property((String)"name", (Object)"n2"));
        GraphExtractionWriterTest.assertNode("42", nodes, Arrays.asList("Foo", "Bar"), Property.property((String)"name", (Object)"n3"));
    }

    private void assertRelationships(JsonNode result) {
        JsonNode relationships = result.get("graph").get("relationships");
        Assert.assertEquals((String)"there should be 2 relationships", (long)2L, (long)relationships.size());
        GraphExtractionWriterTest.assertRelationship("7", relationships, "17", "ONE", "666", Property.property((String)"name", (Object)"r1"));
        GraphExtractionWriterTest.assertRelationship("8", relationships, "17", "TWO", "42", Property.property((String)"name", (Object)"r2"));
    }

    private static void assertNode(String id, JsonNode nodes, List<String> labels, Property ... properties) {
        JsonNode node = GraphExtractionWriterTest.get((Iterable<JsonNode>)nodes, id);
        GraphExtractionWriterTest.assertListEquals("Node[" + id + "].labels", labels, node.get("labels"));
        JsonNode props = node.get("properties");
        Assert.assertEquals((String)("length( Node[" + id + "].properties )"), (long)properties.length, (long)props.size());
        for (Property property : properties) {
            GraphExtractionWriterTest.assertJsonEquals("Node[" + id + "].properties[" + property.key() + "]", property.value(), props.get(property.key()));
        }
    }

    private static void assertRelationship(String id, JsonNode relationships, String startNodeId, String type, String endNodeId, Property ... properties) {
        JsonNode relationship = GraphExtractionWriterTest.get((Iterable<JsonNode>)relationships, id);
        Assert.assertEquals((String)("Relationship[" + id + "].labels"), (Object)type, (Object)relationship.get("type").getTextValue());
        Assert.assertEquals((String)("Relationship[" + id + "].startNode"), (Object)startNodeId, (Object)relationship.get("startNode").getTextValue());
        Assert.assertEquals((String)("Relationship[" + id + "].endNode"), (Object)endNodeId, (Object)relationship.get("endNode").getTextValue());
        JsonNode props = relationship.get("properties");
        Assert.assertEquals((String)("length( Relationship[" + id + "].properties )"), (long)properties.length, (long)props.size());
        for (Property property : properties) {
            GraphExtractionWriterTest.assertJsonEquals("Relationship[" + id + "].properties[" + property.key() + "]", property.value(), props.get(property.key()));
        }
    }

    private static void assertJsonEquals(String message, Object expected, JsonNode actual) {
        if (expected == null) {
            Assert.assertTrue((String)message, (actual == null || actual.isNull() ? 1 : 0) != 0);
        } else if (expected instanceof String) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual.getTextValue());
        } else if (expected instanceof Number) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual.getNumberValue());
        } else {
            Assert.fail((String)(message + " - unexpected type - " + expected));
        }
    }

    private static void assertListEquals(String what, List<String> expected, JsonNode jsonNode) {
        Assert.assertTrue((String)(what + " - should be a list"), (boolean)jsonNode.isArray());
        ArrayList<String> actual = new ArrayList<String>(jsonNode.size());
        for (JsonNode node : jsonNode) {
            actual.add(node.getTextValue());
        }
        Assert.assertEquals((String)what, expected, actual);
    }

    private static JsonNode get(Iterable<JsonNode> jsonNodes, String id) {
        for (JsonNode jsonNode : jsonNodes) {
            if (!id.equals(jsonNode.get("id").getTextValue())) continue;
            return jsonNode;
        }
        return null;
    }
}

