/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ConfigFileBuilder;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.rule.SuppressOutput;

public class ConfigLoaderTest {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void shouldProvideAConfiguration() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldUseSpecifiedConfigFile() throws Exception {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", (Object)testConf.get(GraphDatabaseSettings.default_advertised_address));
    }

    @Test
    public void shouldUseSpecifiedHomeDir() throws Exception {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config testConf = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertEquals((Object)this.folder.getRoot(), (Object)testConf.get(GraphDatabaseSettings.neo4j_home));
    }

    @Test
    public void shouldUseWorkingDirForHomeDirIfUnspecified() throws Exception {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config testConf = ConfigLoader.loadConfig(Optional.empty(), configFile, (Pair[])new Pair[0]);
        Assert.assertEquals((Object)new File(System.getProperty("user.dir")), (Object)testConf.get(GraphDatabaseSettings.neo4j_home));
    }

    @Test
    public void shouldAcceptDuplicateKeysWithSameValue() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").withNameValue(GraphDatabaseSettings.default_advertised_address.name(), "bar").build();
        Config testConf = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", (Object)testConf.get(GraphDatabaseSettings.default_advertised_address));
    }

    @Test
    public void loadOfflineConfigShouldDisableBolt() throws IOException {
        BoltConnector defaultBoltConf = new BoltConnector("bolt");
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(defaultBoltConf.enabled.name(), "true").build();
        Config testConf = ConfigLoader.loadConfigWithConnectorsDisabled(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertNotNull((Object)testConf);
        Assert.assertEquals((Object)false, (Object)testConf.get(defaultBoltConf.enabled));
        Assert.assertEquals((Object)false, (Object)testConf.get(new BoltConnector().enabled));
    }

    @Test
    public void loadOfflineConfigAddDisabledBoltConnector() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).build();
        Config testConf = ConfigLoader.loadConfigWithConnectorsDisabled(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertNotNull((Object)testConf);
        Assert.assertEquals((Object)false, (Object)testConf.get(new BoltConnector().enabled));
    }

    @Test
    public void shouldFindThirdPartyJaxRsPackages() throws IOException {
        File file = ServerTestUtils.createTempConfigFile(this.folder.getRoot());
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file, true));){
            out.write(ServerSettings.third_party_packages.name());
            out.write("=");
            out.write("com.foo.bar=\"mount/point/foo\",");
            out.write("com.foo.baz=\"/bar\",");
            out.write("com.foo.foobarbaz=\"/\"");
            out.write(System.lineSeparator());
        }
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), Optional.of(file), (Pair[])new Pair[0]);
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        Assert.assertNotNull((Object)thirdpartyJaxRsPackages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
    }

    @Test
    public void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withNameValue(ServerSettings.third_party_packages.name(), "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
        Assert.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        Assert.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        Assert.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }

    @Test
    public void shouldWorkFineWhenSpecifiedConfigFileDoesNotExist() throws IOException {
        Optional<File> nonExistentConfigFile = Optional.of(new File("/tmp/" + System.currentTimeMillis()));
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), nonExistentConfigFile, (Pair[])new Pair[0]);
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldDefaultToCorrectValueForAuthStoreLocation() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withoutSetting(DatabaseManagementSystemSettings.data_directory).build();
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertThat((Object)config.get(DatabaseManagementSystemSettings.auth_store_directory), (Matcher)Matchers.is((Object)new File(this.folder.getRoot(), "data/dbms").getAbsoluteFile()));
    }

    @Test
    public void shouldSetAValueForAuthStoreLocation() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withSetting(DatabaseManagementSystemSettings.data_directory, "the-data-dir").build();
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertThat((Object)config.get(DatabaseManagementSystemSettings.auth_store_directory), (Matcher)Matchers.is((Object)new File(this.folder.getRoot(), "the-data-dir/dbms").getAbsoluteFile()));
    }

    @Test
    public void shouldNotOverwriteAuthStoreLocationIfProvided() throws IOException {
        Optional<File> configFile = ConfigFileBuilder.builder(this.folder.getRoot()).withSetting(DatabaseManagementSystemSettings.data_directory, "the-data-dir").withSetting(GraphDatabaseSettings.auth_store, "foo/bar/auth").build();
        Config config = ConfigLoader.loadConfig(Optional.of(this.folder.getRoot()), configFile, (Pair[])new Pair[0]);
        Assert.assertThat((Object)config.get(GraphDatabaseSettings.auth_store), (Matcher)Matchers.is((Object)new File(this.folder.getRoot(), "foo/bar/auth").getAbsoluteFile()));
    }
}

