/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.server.HTTP;

public class QueryResultsSerializationTest
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri("http://localhost:7474");
    private String commitResource;

    @Before
    public void setUp() {
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        this.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.stringFromContent("commit");
        }
        catch (JsonParseException e) {
            Assert.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
    }

    @After
    public void tearDown() {
        this.graphdb().execute("MATCH (n) DETACH DELETE n");
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesGraph() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(2));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesRest() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsDeletedEntities(3));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedEntitiesRow() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) DELETE s, r, e RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(2, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedGraph() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsNoDeletedEntities());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedRow() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsNoDeletedEntities());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void shouldNotMarkNormalEntitiesAsDeletedRest() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s:Start)-[r:R]->(e:End) RETURN *"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsNoDeletedEntities());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesGraph() {
        this.graphdb().execute("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesRow() {
        this.graphdb().execute("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(1, 0));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedNodesRest() {
        this.graphdb().execute("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN n"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsDeletedEntities(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsGraph() {
        this.graphdb().execute("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsRow() {
        this.graphdb().execute("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(0, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToReturnDeletedRelationshipsRest() {
        this.graphdb().execute("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s)-[r:R]->(e) DELETE r RETURN r"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.restContainsDeletedEntities(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeGraph() {
        this.graphdb().execute("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeRow() {
        this.graphdb().execute("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedNodeRest() {
        this.graphdb().execute("CREATE (:NodeToDelete {p: 'a property'})");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN n.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeGraph() {
        this.graphdb().execute("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeRow() {
        this.graphdb().execute("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnLabelsOfDeletedNodeRest() {
        this.graphdb().execute("CREATE (:NodeToDelete)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n:NodeToDelete) DELETE n RETURN labels(n)"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipGraph() {
        this.graphdb().execute("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipRow() {
        this.graphdb().execute("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void shouldFailIfTryingToReturnPropsOfDeletedRelationshipRest() {
        this.graphdb().execute("CREATE (:Start)-[:R {p: 'a property'}]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (s)-[r:R]->(e) DELETE r RETURN r.p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.hasErrors(new Status[]{Status.Statement.EntityNotFound}));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void returningADeletedPathGraph() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(2));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void returningAPartiallyDeletedPathGraph() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(1));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedRelationships(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void returningADeletedPathRow() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntitiesInPath(2, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void returningAPartiallyDeletedPathRow() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntitiesInPath(1, 1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void returningADeletedPathRest() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH p=(s)-[r:R]->(e) DELETE p RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void returningAPartiallyDeletedPathRest() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH p=(s)-[r:R]->(e) DELETE s,r RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void nestedShouldWorkGraph() {
        this.graphdb().execute("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonGraph("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.graphContainsDeletedNodes(1));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void nestedShouldWorkRest() {
        this.graphdb().execute("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRest("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit, QueryResultsSerializationTest.restContainsNestedDeleted());
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void nestedShouldWorkRow() {
        this.graphdb().execute("CREATE ()");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (n) DELETE (n) RETURN [n, {someKey: n}]"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsDeletedEntities(2, 0));
        MatcherAssert.assertThat((Object)this.nodesInDatabase(), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    private HTTP.RawPayload queryAsJsonGraph(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'graph' ] } ] }");
    }

    private HTTP.RawPayload queryAsJsonRest(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'rest' ] } ] }");
    }

    private HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'row' ] } ] }");
    }

    private long nodesInDatabase() {
        Result r = this.graphdb().execute("MATCH (n) RETURN count(n) AS c");
        Long nodes = (Long)r.columnAs("c").next();
        r.close();
        return nodes;
    }

    private void assertHasTxLocation(HTTP.Response begin) {
        MatcherAssert.assertThat((Object)begin.location(), TransactionMatchers.matches("http://localhost:\\d+/db/data/transaction/\\d+"));
    }

    public static Matcher<? super HTTP.Response> restContainsNestedDeleted() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    JsonNode list = (JsonNode)TransactionMatchers.getJsonNodeWithName(response, "rest").iterator().next();
                    MatcherAssert.assertThat((Object)list.get(0).get("metadata").get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    MatcherAssert.assertThat((Object)list.get(1).get("someKey").get("metadata").get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }
}

