/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.exception;

import java.util.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedException;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.exception.UpgradeDisallowedStartupException;

public class ServerStartupErrors {
    private static final Function<Throwable, ServerStartupException>[] translators = new Function[]{new Function<Throwable, ServerStartupException>(){

        @Override
        public ServerStartupException apply(Throwable o) {
            Throwable rootCause = Exceptions.rootCause((Throwable)o);
            if (rootCause instanceof UpgradeNotAllowedException) {
                return new UpgradeDisallowedStartupException((UpgradeNotAllowedException)rootCause);
            }
            return null;
        }
    }};

    private ServerStartupErrors() {
    }

    public static ServerStartupException translateToServerStartupError(Throwable cause) {
        for (Function<Throwable, ServerStartupException> translator : translators) {
            ServerStartupException r = translator.apply(cause);
            if (r == null) continue;
            return r;
        }
        return new ServerStartupException(String.format("Starting Neo4j failed: %s", cause.getMessage()), cause);
    }
}

