/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerJAXRSIT
extends ExclusiveServerTestBase {
    private NeoServer server;

    @Before
    public void cleanTheDatabase() {
        ServerHelper.cleanTheDatabase(this.server);
    }

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void shouldMakeJAXRSClassesAvailableViaHTTP() throws Exception {
        CommunityServerBuilder builder = CommunityServerBuilder.server();
        this.server = ServerHelper.createNonPersistentServer(builder);
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(this.server);
        JaxRsResponse response = new RestRequest().get(functionalTestHelper.managementUri());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldLoadThirdPartyJaxRsClasses() throws Exception {
        this.server = CommunityServerBuilder.server().withThirdPartyJaxRsPackage("org.dummy.web.service", "/dummy").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        URI thirdPartyServiceUri = new URI(this.server.baseUri().toString() + "/dummy").normalize();
        String response = (String)FunctionalTestHelper.CLIENT.resource(thirdPartyServiceUri.toString()).get(String.class);
        Assert.assertEquals((Object)"hello", (Object)response);
        int nodesCreated = this.createSimpleDatabase((GraphDatabaseAPI)this.server.getDatabase().getGraph());
        thirdPartyServiceUri = new URI(this.server.baseUri().toString() + "/dummy" + "/inject-test").normalize();
        response = (String)FunctionalTestHelper.CLIENT.resource(thirdPartyServiceUri.toString()).get(String.class);
        Assert.assertEquals((Object)String.valueOf(nodesCreated), (Object)response);
    }

    private int createSimpleDatabase(GraphDatabaseAPI graph) {
        int numberOfNodes = 10;
        new Transactor((GraphDatabaseService)graph, () -> {
            for (int i = 0; i < 10; ++i) {
                graph.createNode();
            }
            for (Node n1 : graph.getAllNodes()) {
                for (Node n2 : graph.getAllNodes()) {
                    if (n1.equals(n2)) continue;
                    n1.createRelationshipTo(n2, RelationshipType.withName((String)"REL"));
                }
            }
        }).execute();
        return 10;
    }
}

