/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.server.NeoServer;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.test.server.ExclusiveServerTestBase;

public abstract class NeoServerRestartTestIT
extends ExclusiveServerTestBase {
    public static final String CUSTOM_SWAPPER = "CustomSwapper";
    private static Semaphore semaphore = new Semaphore(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRestartWhenStoppedDuringStartup() throws IOException, InterruptedException {
        semaphore.drainPermits();
        NeoServer server = this.getNeoServer(CUSTOM_SWAPPER);
        try {
            AtomicBoolean failure = new AtomicBoolean();
            Thread serverStoppingThread = ThreadTestUtils.fork((Runnable)this.stopServerAfterStartingHasStarted(server, failure));
            server.start();
            serverStoppingThread.join();
            if (failure.get()) {
                Assert.fail((String)"Server failed to stop.");
            }
            server = this.getNeoServer(CUSTOM_SWAPPER);
            server.start();
        }
        finally {
            server.stop();
        }
    }

    protected abstract NeoServer getNeoServer(String var1) throws IOException;

    private Runnable stopServerAfterStartingHasStarted(NeoServer server, AtomicBoolean failure) {
        return () -> {
            try {
                semaphore.acquire();
                server.stop();
            }
            catch (Exception e) {
                failure.set(true);
                e.printStackTrace();
            }
        };
    }

    public static class CustomSwapper
    extends SingleFilePageSwapperFactory {
        public String implementationName() {
            return NeoServerRestartTestIT.CUSTOM_SWAPPER;
        }

        public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist) throws IOException {
            semaphore.release();
            return super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist);
        }
    }
}

