/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.transactional.integration.TransactionMatchers;
import org.neo4j.test.server.HTTP;

public class RowFormatMetaFieldTestIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri("http://localhost:7474");
    private String commitResource;

    @Before
    public void setUp() {
        HTTP.Response begin = this.http.POST("/db/data/transaction");
        MatcherAssert.assertThat((Object)begin.status(), (Matcher)CoreMatchers.equalTo((Object)201));
        this.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.stringFromContent("commit");
        }
        catch (JsonParseException e) {
            Assert.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        MatcherAssert.assertThat((Object)this.commitResource, (Matcher)CoreMatchers.equalTo((Object)(begin.location() + "/commit")));
    }

    @After
    public void tearDown() {
        this.graphdb().execute("MATCH (n) DETACH DELETE n");
    }

    @Test
    public void metaFieldShouldGetCorrectIndex() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) RETURN s, r, 1, e"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsMetaNodesAtIndex(0, 3));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsMetaRelsAtIndex(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void metaFieldShouldGivePathInfoInList() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) RETURN p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsAMetaListAtIndex(0));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    @Test
    public void metaFieldShouldPutPathListAtCorrectIndex() {
        this.graphdb().execute("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, this.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) RETURN 10, p"));
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.containsNoErrors());
        MatcherAssert.assertThat((Object)commit, TransactionMatchers.rowContainsAMetaListAtIndex(1));
        MatcherAssert.assertThat((Object)commit.status(), (Matcher)CoreMatchers.equalTo((Object)200));
    }

    private HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'row' ] } ] }");
    }

    private void assertHasTxLocation(HTTP.Response begin) {
        MatcherAssert.assertThat((Object)begin.location(), TransactionMatchers.matches("http://localhost:\\d+/db/data/transaction/\\d+"));
    }
}

