/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.management.JmxService;
import org.neo4j.server.rest.management.RootService;
import org.neo4j.server.rest.management.VersionAndEditionService;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.rest.management.console.ConsoleSessionFactory;
import org.neo4j.server.rest.management.console.ScriptSession;
import org.neo4j.server.rest.management.console.ShellSession;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.shell.ShellSettings;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestData;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.EntityOutputFormat;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class ManageNodeIT
extends AbstractRestFunctionalDocTestBase {
    private static final long NON_EXISTENT_NODE_ID = 999999L;
    private static String NODE_URI_PATTERN = "^.*/node/[0-9]+$";
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(ManageNodeIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Test
    public void create_node() throws Exception {
        JaxRsResponse response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(201).expectedHeader("Location").post(functionalTestHelper.nodeUri()).response();
        Assert.assertTrue((boolean)response.getLocation().toString().matches(NODE_URI_PATTERN));
    }

    @Test
    public void create_node_with_properties() throws Exception {
        JaxRsResponse response = ((RESTRequestGenerator)this.gen.get()).payload("{\"foo\" : \"bar\"}").expectedStatus(201).expectedHeader("Location").expectedHeader("Content-Length").post(functionalTestHelper.nodeUri()).response();
        Assert.assertTrue((boolean)response.getLocation().toString().matches(NODE_URI_PATTERN));
    }

    @Test
    public void create_node_with_array_properties() throws Exception {
        String response = ((RESTRequestGenerator)this.gen.get()).payload("{\"foo\" : [1,2,3]}").expectedStatus(201).expectedHeader("Location").expectedHeader("Content-Length").post(functionalTestHelper.nodeUri()).response().getEntity();
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"[ 1, 2, 3 ]"));
    }

    @Documented(value="Property values can not be null.\n\nThis example shows the response you get when trying to set a property to +null+.")
    @Test
    public void shouldGet400WhenSupplyingNullValueForAProperty() throws Exception {
        ((RESTRequestGenerator)this.gen.get()).payload("{\"foo\":null}").expectedStatus(400).post(functionalTestHelper.nodeUri());
    }

    @Test
    public void shouldGet400WhenCreatingNodeMalformedProperties() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer("this:::isNot::JSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldGet400WhenCreatingNodeUnsupportedNestedPropertyValues() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer("{\"foo\" : {\"bar\" : \"baz\"}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    private JaxRsResponse sendCreateRequestToServer(String json) {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/", json);
    }

    private JaxRsResponse sendCreateRequestToServer() {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/", null, MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void shouldGetValidLocationHeaderWhenCreatingNode() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer();
        Assert.assertNotNull((Object)response.getLocation());
        Assert.assertTrue((boolean)response.getLocation().toString().startsWith(functionalTestHelper.dataUri() + "node/"));
    }

    @Test
    public void shouldGetASingleContentLengthHeaderWhenCreatingANode() {
        JaxRsResponse response = this.sendCreateRequestToServer();
        List contentLentgthHeaders = (List)response.getHeaders().get((Object)"Content-Length");
        Assert.assertNotNull((Object)contentLentgthHeaders);
        Assert.assertEquals((long)1L, (long)contentLentgthHeaders.size());
    }

    @Test
    public void shouldBeJSONContentTypeOnResponse() {
        JaxRsResponse response = this.sendCreateRequestToServer();
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
    }

    @Test
    public void shouldGetValidNodeRepresentationWhenCreatingNode() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer();
        String entity = response.getEntity();
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    @Documented(value="Delete node.")
    @Test
    public void shouldRespondWith204WhenNodeDeleted() throws Exception {
        long node = helper.createNode(new Label[0]);
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).delete(functionalTestHelper.dataUri() + "node/" + node);
    }

    @Test
    public void shouldRespondWith404AndSensibleEntityBodyWhenNodeToBeDeletedCannotBeFound() throws Exception {
        JaxRsResponse response = this.sendDeleteRequestToServer(999999L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertThat((Object)jsonMap, (Matcher)Matchers.hasKey((Object)"message"));
        Assert.assertNotNull(jsonMap.get("message"));
    }

    @Documented(value="Nodes with relationships cannot be deleted.\n\nThe relationships on a node has to be deleted before the node can be\ndeleted.\n \nTIP: You can use `DETACH DELETE` in Cypher to delete nodes and their relationships in one go.")
    @Test
    public void shouldRespondWith409AndSensibleEntityBodyWhenNodeCannotBeDeleted() throws Exception {
        long id = helper.createNode(new Label[0]);
        helper.createRelationship("LOVES", id, helper.createNode(new Label[0]));
        JaxRsResponse response = this.sendDeleteRequestToServer(id);
        Assert.assertEquals((long)409L, (long)response.getStatus());
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertThat((Object)jsonMap, (Matcher)Matchers.hasKey((Object)"message"));
        Assert.assertNotNull(jsonMap.get("message"));
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(409).delete(functionalTestHelper.dataUri() + "node/" + id);
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodePropertiesDuringNodeCreation() throws URISyntaxException {
        String mangledJsonArray = "{\"myprop\":[1,2,\"three\"]}";
        JaxRsResponse response = this.sendCreateRequestToServer(mangledJsonArray);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)mangledJsonArray));
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodeProperty() throws URISyntaxException {
        URI nodeLocation = this.sendCreateRequestToServer().getLocation();
        String mangledJsonArray = "[1,2,\"three\"]";
        JaxRsResponse response = RestRequest.req().put(nodeLocation.toString() + "/properties/myprop", mangledJsonArray);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)mangledJsonArray));
        response.close();
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodeProperties() throws URISyntaxException {
        URI nodeLocation = this.sendCreateRequestToServer().getLocation();
        String mangledJsonProperties = "{\"a\":\"b\", \"c\":[1,2,\"three\"]}";
        JaxRsResponse response = RestRequest.req().put(nodeLocation.toString() + "/properties", mangledJsonProperties);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)mangledJsonProperties));
        response.close();
    }

    private JaxRsResponse sendDeleteRequestToServer(long id) throws Exception {
        return RestRequest.req().delete(functionalTestHelper.dataUri() + "node/" + id);
    }

    public static class VersionAndEditionServiceTest {
        @Test
        public void shouldReturnReadableStringForServiceName() throws Exception {
            VersionAndEditionService service = new VersionAndEditionService((NeoServer)Mockito.mock(CommunityNeoServer.class));
            String serviceName = service.getName();
            Assert.assertEquals((Object)"version", (Object)serviceName);
        }

        @Test
        public void shouldReturnSensiblePathWhereServiceIsHosted() throws Exception {
            VersionAndEditionService service = new VersionAndEditionService((NeoServer)Mockito.mock(CommunityNeoServer.class));
            String serverPath = service.getServerPath();
            Assert.assertEquals((Object)"server/version", (Object)serverPath);
        }
    }

    public static class RootServiceDocTest {
        @Test
        public void shouldAdvertiseServicesWhenAsked() throws Exception {
            UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
            URI uri = new URI("http://example.org:7474/");
            Mockito.when((Object)uriInfo.getBaseUri()).thenReturn((Object)uri);
            RootService svc = new RootService((NeoServer)new CommunityNeoServer(Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).type.name(), "HTTP", new HttpConnector((String)"http", (HttpConnector.Encryption)HttpConnector.Encryption.NONE).enabled.name(), "true"})), (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance()).monitors(new Monitors()), (LogProvider)NullLogProvider.getInstance()));
            EntityOutputFormat output = new EntityOutputFormat((RepresentationFormat)new JsonFormat(), null, null);
            Response serviceDefinition = svc.getServiceDefinition(uriInfo, (OutputFormat)output);
            Assert.assertEquals((long)200L, (long)serviceDefinition.getStatus());
            Map result = (Map)output.getResultAsMap().get("services");
            Assert.assertThat((Object)result.get("console").toString(), (Matcher)Matchers.containsString((String)String.format("%sserver/console", uri.toString())));
            Assert.assertThat((Object)result.get("jmx").toString(), (Matcher)Matchers.containsString((String)String.format("%sserver/jmx", uri.toString())));
        }
    }

    public static class Neo4jShellConsoleSessionDocTest
    implements ConsoleSessionFactory {
        private ConsoleService consoleService;
        private Database database;
        private final URI uri = URI.create("http://peteriscool.com:6666/");

        @Before
        public void setUp() throws Exception {
            this.database = new WrappedDatabase((GraphDatabaseFacade)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(ShellSettings.remote_shell_enabled, "true").newGraphDatabase());
            this.consoleService = new ConsoleService((ConsoleSessionFactory)this, this.database, (LogProvider)NullLogProvider.getInstance(), new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
        }

        @After
        public void shutdownDatabase() {
            this.database.getGraph().shutdown();
        }

        public ScriptSession createSession(String engineName, Database database, LogProvider logProvider) {
            return new ShellSession((GraphDatabaseAPI)database.getGraph());
        }

        @Test
        public void doesntMangleNewlines() throws Exception {
            Response response = this.consoleService.exec((InputFormat)new JsonFormat(), "{ \"command\" : \"create (n) return n;\", \"engine\":\"shell\" }");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            String result = this.decode(response).get(0);
            String expected = "+-----------+" + System.lineSeparator() + "| n         |" + System.lineSeparator() + "+-----------+" + System.lineSeparator() + "| Node[0]{} |" + System.lineSeparator() + "+-----------+" + System.lineSeparator() + "1 row";
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsString((String)expected));
        }

        private List<String> decode(Response response) throws JsonParseException {
            return (List)JsonHelper.readJson((String)UTF8.decode((byte[])((byte[])response.getEntity())));
        }

        public Iterable<String> supportedEngines() {
            return new ArrayList<String>(){
                {
                    this.add("shell");
                }
            };
        }
    }

    public static class JmxServiceDocTest {
        public JmxService jmxService;
        private final URI uri = URI.create("http://peteriscool.com:6666/");

        @Test
        public void correctRepresentation() throws URISyntaxException {
            Response resp = this.jmxService.getServiceDefinition();
            Assert.assertEquals((long)200L, (long)resp.getStatus());
            String json = UTF8.decode((byte[])((byte[])resp.getEntity()));
            MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"resources"));
            MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)this.uri.toString()));
            MatcherAssert.assertThat((Object)json, (Matcher)Matchers.containsString((String)"jmx/domain/{domain}/{objectName}"));
        }

        @Test
        public void shouldListDomainsCorrectly() throws Exception {
            Response resp = this.jmxService.listDomains();
            Assert.assertEquals((long)200L, (long)resp.getStatus());
        }

        @Test
        public void testwork() throws Exception {
            this.jmxService.queryBeans("[\"*:*\"]");
        }

        @Before
        public void setUp() throws Exception {
            this.jmxService = new JmxService(new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null), null);
        }
    }

    public static class ConsoleServiceDocTest {
        private final URI uri = URI.create("http://peteriscool.com:6666/");

        @Test
        public void correctRepresentation() throws URISyntaxException {
            ConsoleService consoleService = new ConsoleService((ConsoleSessionFactory)new ShellOnlyConsoleSessionFactory(), (Database)Mockito.mock(Database.class), (LogProvider)NullLogProvider.getInstance(), new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
            Response consoleResponse = consoleService.getServiceDefinition();
            Assert.assertEquals((long)200L, (long)consoleResponse.getStatus());
            String response = this.decode(consoleResponse);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"resources"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)this.uri.toString()));
        }

        @Test
        public void advertisesAvailableConsoleEngines() throws URISyntaxException {
            ConsoleService consoleServiceWithJustShellEngine = new ConsoleService((ConsoleSessionFactory)new ShellOnlyConsoleSessionFactory(), (Database)Mockito.mock(Database.class), (LogProvider)NullLogProvider.getInstance(), new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
            String response = this.decode(consoleServiceWithJustShellEngine.getServiceDefinition());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"engines\" : [ \"shell\" ]"));
        }

        private String decode(Response response) {
            return UTF8.decode((byte[])((byte[])response.getEntity()));
        }

        private static class ShellOnlyConsoleSessionFactory
        implements ConsoleSessionFactory {
            private ShellOnlyConsoleSessionFactory() {
            }

            public ScriptSession createSession(String engineName, Database database, LogProvider logProvider) {
                return null;
            }

            public Iterable<String> supportedEngines() {
                return Collections.singletonList("shell");
            }
        }
    }

    public static class ConfigureEnabledManagementConsolesDocIT
    extends ExclusiveServerTestBase {
        private NeoServer server;

        @After
        public void stopTheServer() {
            this.server.stop();
        }

        @Test
        public void shouldBeAbleToExplicitlySetConsolesToEnabled() throws Exception {
            this.server = CommunityServerBuilder.server().withProperty(ServerSettings.console_module_engines.name(), "").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
            this.server.start();
            Assert.assertThat((Object)this.exec("ls", "shell").getStatus(), (Matcher)Matchers.is((Object)400));
        }

        @Test
        public void shellConsoleShouldBeEnabledByDefault() throws Exception {
            this.server = CommunityServerBuilder.server().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
            this.server.start();
            Assert.assertThat((Object)this.exec("ls", "shell").getStatus(), (Matcher)Matchers.is((Object)200));
        }

        private JaxRsResponse exec(String command, String engine) {
            return RestRequest.req().post(this.server.baseUri() + "db/manage/server/console", "{\"engine\":\"" + engine + "\",\"command\":\"" + command + "\\n\"}");
        }
    }

    public static class CommunityVersionAndEditionServiceDocIT
    extends ExclusiveServerTestBase {
        private static NeoServer server;
        private static FunctionalTestHelper functionalTestHelper;
        @ClassRule
        public static TemporaryFolder staticFolder;
        @Rule
        public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);
        private static FakeClock clock;

        @BeforeClass
        public static void setupServer() throws Exception {
            clock = Clocks.fakeClock();
            server = CommunityServerBuilder.server().usingDataDir(staticFolder.getRoot().getAbsolutePath()).withClock((Clock)clock).build();
            SuppressOutput.suppressAll().call(() -> {
                server.start();
                return null;
            });
            functionalTestHelper = new FunctionalTestHelper(server);
        }

        @Before
        public void setupTheDatabase() throws Exception {
        }

        @AfterClass
        public static void stopServer() throws Exception {
            SuppressOutput.suppressAll().call(() -> {
                server.stop();
                return null;
            });
        }

        @Test
        public void shouldReportCommunityEdition() throws Exception {
            String releaseVersion = ((KernelData)server.getDatabase().getGraph().getDependencyResolver().resolveDependency(KernelData.class)).version().getReleaseVersion();
            HTTP.Response res = HTTP.GET(functionalTestHelper.managementUri() + "/" + "server/version");
            Assert.assertEquals((long)200L, (long)res.status());
            Assert.assertThat((Object)res.get("edition").asText(), (Matcher)Matchers.equalTo((Object)"community"));
            Assert.assertThat((Object)res.get("version").asText(), (Matcher)Matchers.equalTo((Object)releaseVersion));
        }

        static {
            staticFolder = new TemporaryFolder();
        }
    }
}

