/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.paging.PagedTraverser;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class LeaseManagerTest {
    private static final long SIXTY_SECONDS = 60L;

    @Test
    public void shouldNotAcceptLeasesWithNegativeTTL() throws Exception {
        FakeClock fakeClock = Clocks.fakeClock();
        LeaseManager manager = new LeaseManager((Clock)fakeClock);
        Assert.assertNull((Object)manager.createLease(-1L, (PagedTraverser)Mockito.mock(PagedTraverser.class)));
        Assert.assertNull((Object)manager.createLease(Long.MIN_VALUE, (PagedTraverser)Mockito.mock(PagedTraverser.class)));
    }

    @Test
    public void shouldRetrieveAnExistingLeaseImmediatelyAfterCreation() throws Exception {
        FakeClock fakeClock = Clocks.fakeClock();
        LeaseManager manager = new LeaseManager((Clock)fakeClock);
        Lease lease = manager.createLease(60L, (PagedTraverser)Mockito.mock(PagedTraverser.class));
        Assert.assertNotNull((Object)manager.getLeaseById(lease.getId()));
    }

    @Test
    public void shouldRetrieveAnExistingLeaseSomeTimeAfterCreation() throws Exception {
        FakeClock fakeClock = Clocks.fakeClock();
        LeaseManager manager = new LeaseManager((Clock)fakeClock);
        Lease lease = manager.createLease(120L, (PagedTraverser)Mockito.mock(PagedTraverser.class));
        fakeClock.forward(1L, TimeUnit.MINUTES);
        Assert.assertNotNull((Object)manager.getLeaseById(lease.getId()));
    }

    @Test
    public void shouldNotRetrieveALeaseAfterItExpired() throws Exception {
        FakeClock fakeClock = Clocks.fakeClock();
        LeaseManager manager = new LeaseManager((Clock)fakeClock);
        Lease lease = manager.createLease(60L, (PagedTraverser)Mockito.mock(PagedTraverser.class));
        fakeClock.forward(2L, TimeUnit.MINUTES);
        Assert.assertNull((Object)manager.getLeaseById(lease.getId()));
    }

    @Test
    public void shouldNotBarfWhenAnotherThreadOrRetrieveRevokesTheLease() throws Exception {
        FakeClock fakeClock = Clocks.fakeClock();
        LeaseManager manager = new LeaseManager((Clock)fakeClock);
        Lease leaseA = manager.createLease(60L, (PagedTraverser)Mockito.mock(PagedTraverser.class));
        Lease leaseB = manager.createLease(180L, (PagedTraverser)Mockito.mock(PagedTraverser.class));
        fakeClock.forward(2L, TimeUnit.MINUTES);
        Assert.assertNotNull((Object)manager.getLeaseById(leaseB.getId()));
        Assert.assertNull((Object)manager.getLeaseById(leaseA.getId()));
    }

    @Test
    public void shouldRemoveALease() {
        FakeClock fakeClock = Clocks.fakeClock();
        LeaseManager manager = new LeaseManager((Clock)fakeClock);
        Lease lease = manager.createLease(101L, (PagedTraverser)Mockito.mock(PagedTraverser.class));
        manager.remove(lease.getId());
        Assert.assertNull((Object)manager.getLeaseById(lease.getId()));
    }
}

