/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.integration;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class StartupLoggingIT
extends ExclusiveServerTestBase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TestDirectory homeDir = TestDirectory.testDirectory();

    @Before
    public void setUp() throws IOException {
        FileUtils.deleteRecursively((File)ServerTestUtils.getRelativeFile((Setting<File>)DatabaseManagementSystemSettings.data_directory));
    }

    @Test
    public void shouldLogHelpfulStartupMessages() throws Throwable {
        CommunityBootstrapper boot = new CommunityBootstrapper();
        Pair[] propertyPairs = this.getPropertyPairs();
        boot.start(this.homeDir.directory(), Optional.of(new File("nonexistent-file.conf")), propertyPairs);
        URI uri = boot.getServer().baseUri();
        boot.stop();
        List captured = this.suppressOutput.getOutputVoice().lines();
        MatcherAssert.assertThat((Object)captured, StartupLoggingIT.containsAtLeastTheseLines(StartupLoggingIT.warn("Config file \\[nonexistent-file.conf\\] does not exist."), StartupLoggingIT.info(AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE), StartupLoggingIT.info("Starting..."), StartupLoggingIT.info("Started."), StartupLoggingIT.info("Remote interface available at " + uri.toString()), StartupLoggingIT.info("Stopping..."), StartupLoggingIT.info("Stopped.")));
    }

    private Pair[] getPropertyPairs() throws IOException {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        Map<String, String> relativeProperties = ServerTestUtils.getDefaultRelativeProperties();
        for (Map.Entry<String, String> entry : relativeProperties.entrySet()) {
            pairs.add(Pair.of((Object)entry.getKey(), (Object)entry.getValue()));
        }
        pairs.add(Pair.of((Object)GraphDatabaseSettings.allow_store_upgrade.name(), (Object)"true"));
        HttpConnector http = new HttpConnector("http", HttpConnector.Encryption.NONE);
        pairs.add(Pair.of((Object)http.type.name(), (Object)"HTTP"));
        pairs.add(Pair.of((Object)http.listen_address.name(), (Object)"localhost:0"));
        pairs.add(Pair.of((Object)http.enabled.name(), (Object)"true"));
        HttpConnector https = new HttpConnector("https", HttpConnector.Encryption.TLS);
        pairs.add(Pair.of((Object)https.type.name(), (Object)"HTTP"));
        pairs.add(Pair.of((Object)https.listen_address.name(), (Object)"localhost:0"));
        pairs.add(Pair.of((Object)https.enabled.name(), (Object)"true"));
        BoltConnector bolt = new BoltConnector("bolt");
        pairs.add(Pair.of((Object)bolt.type.name(), (Object)"BOLT"));
        pairs.add(Pair.of((Object)bolt.enabled.name(), (Object)"true"));
        pairs.add(Pair.of((Object)bolt.listen_address.name(), (Object)"localhost:0"));
        return pairs.toArray(new Pair[pairs.size()]);
    }

    @SafeVarargs
    private static Matcher<List<String>> containsAtLeastTheseLines(final Matcher<String> ... expectedLinePatterns) {
        return new TypeSafeMatcher<List<String>>(){

            protected boolean matchesSafely(List<String> lines) {
                if (expectedLinePatterns.length > lines.size()) {
                    return false;
                }
                int e = 0;
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    while (!expectedLinePatterns[e].matches((Object)line)) {
                        if (++i >= lines.size()) {
                            return false;
                        }
                        line = lines.get(i);
                    }
                    ++e;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("", "\n", "", Arrays.asList(expectedLinePatterns));
            }
        };
    }

    public static Matcher<String> info(String messagePattern) {
        return StartupLoggingIT.line("INFO", messagePattern);
    }

    public static Matcher<String> warn(String messagePattern) {
        return StartupLoggingIT.line("WARN", messagePattern);
    }

    public static Matcher<String> line(final String level, final String messagePattern) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String line) {
                return line.matches(".*" + level + "\\s+" + messagePattern);
            }

            public void describeTo(Description description) {
                description.appendText(level).appendText(" ").appendText(messagePattern);
            }
        };
    }
}

