/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.server.rest.dbms.DelegatingPrincipal;

public class AuthorizedRequestWrapper
extends HttpServletRequestWrapper {
    private final String authType;
    private final DelegatingPrincipal principal;

    public static SecurityContext getSecurityContextFromHttpServletRequest(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        return AuthorizedRequestWrapper.getSecurityContextFromUserPrincipal(principal);
    }

    public static SecurityContext getSecurityContextFromHttpContext(HttpContext httpContext) {
        HttpRequestContext requestContext = httpContext.getRequest();
        Principal principal = requestContext.getUserPrincipal();
        return AuthorizedRequestWrapper.getSecurityContextFromUserPrincipal(principal);
    }

    public static SecurityContext getSecurityContextFromUserPrincipal(Principal principal) {
        if (principal instanceof DelegatingPrincipal) {
            return ((DelegatingPrincipal)principal).getSecurityContext();
        }
        return AnonymousContext.none();
    }

    public AuthorizedRequestWrapper(String authType, String username, HttpServletRequest request, SecurityContext securityContext) {
        super(request);
        this.authType = authType;
        this.principal = new DelegatingPrincipal(username, securityContext);
    }

    public String getAuthType() {
        return this.authType;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return true;
    }

    public String toString() {
        return "AuthorizedRequestWrapper{authType='" + this.authType + '\'' + ", principal=" + this.principal + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AuthorizedRequestWrapper that = (AuthorizedRequestWrapper)((Object)o);
        if (!this.authType.equals(that.authType)) {
            return false;
        }
        return this.principal.equals(that.principal);
    }

    public int hashCode() {
        int result = this.authType.hashCode();
        result = 31 * result + this.principal.hashCode();
        return result;
    }
}

