/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;

public class SetRelationshipPropertiesIT
extends AbstractRestFunctionalDocTestBase {
    private URI propertiesUri;
    private URI badUri;
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(SetRelationshipPropertiesIT.server());
    }

    @Before
    public void setupTheDatabase() throws Exception {
        long relationshipId = new GraphDbHelper(SetRelationshipPropertiesIT.server().getDatabase()).createRelationship("KNOWS");
        this.propertiesUri = new URI(functionalTestHelper.relationshipPropertiesUri(relationshipId));
        this.badUri = new URI(functionalTestHelper.relationshipPropertiesUri(relationshipId + 99999L));
    }

    @Documented(value="Update relationship properties.")
    @Test
    @GraphDescription.Graph
    public void shouldReturn204WhenPropertiesAreUpdated() throws JsonParseException {
        this.data.get();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jim", "tobias");
        ((RESTRequestGenerator)this.gen.get()).payload(JsonHelper.createJsonFrom(map)).expectedStatus(204).put(this.propertiesUri.toString());
        JaxRsResponse response = this.updatePropertiesOnServer(map);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldReturn400WhenSendinIncompatibleJsonProperties() throws JsonParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jim", new HashMap());
        JaxRsResponse response = this.updatePropertiesOnServer(map);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldReturn400WhenSendingCorruptJsonProperties() {
        JaxRsResponse response = RestRequest.req().put(this.propertiesUri.toString(), "this:::Is::notJSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldReturn404WhenPropertiesSentToANodeWhichDoesNotExist() throws JsonParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jim", "tobias");
        JaxRsResponse response = RestRequest.req().put(this.badUri.toString(), JsonHelper.createJsonFrom(map));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    private JaxRsResponse updatePropertiesOnServer(Map<String, Object> map) throws JsonParseException {
        return RestRequest.req().put(this.propertiesUri.toString(), JsonHelper.createJsonFrom(map));
    }

    private String getPropertyUri(String key) throws Exception {
        return this.propertiesUri.toString() + "/" + key;
    }

    @Test
    public void shouldReturn204WhenPropertyIsSet() throws Exception {
        JaxRsResponse response = this.setPropertyOnServer("foo", "bar");
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldReturn400WhenSendinIncompatibleJsonProperty() throws Exception {
        JaxRsResponse response = this.setPropertyOnServer("jim", new HashMap());
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldReturn400WhenSendingCorruptJsonProperty() throws Exception {
        JaxRsResponse response = RestRequest.req().put(this.getPropertyUri("foo"), "this:::Is::notJSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldReturn404WhenPropertySentToANodeWhichDoesNotExist() throws Exception {
        JaxRsResponse response = RestRequest.req().put(this.badUri.toString() + "/foo", JsonHelper.createJsonFrom((Object)"bar"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    private JaxRsResponse setPropertyOnServer(String key, Object value) throws Exception {
        return RestRequest.req().put(this.getPropertyUri(key), JsonHelper.createJsonFrom((Object)value));
    }
}

