/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.repr.DiscoveryRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/")
public class DiscoveryService {
    private final Config config;
    private final OutputFormat outputFormat;
    private final ConnectorPortRegister connectorPortRegister;

    public DiscoveryService(@Context Config config, @Context OutputFormat outputFormat, @Context NeoServer neoServer) {
        this.config = config;
        this.outputFormat = outputFormat;
        this.connectorPortRegister = (ConnectorPortRegister)neoServer.getDatabase().getGraph().getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getDiscoveryDocument(@Context UriInfo uriInfo) throws URISyntaxException {
        String managementUri = ((URI)this.config.get(ServerSettings.management_api_path)).getPath() + "/";
        String dataUri = ((URI)this.config.get(ServerSettings.rest_api_path)).getPath() + "/";
        Optional<AdvertisedSocketAddress> boltAddress = this.config.enabledBoltConnectors().stream().findFirst().map(boltConnector -> (AdvertisedSocketAddress)this.config.get(boltConnector.advertised_address));
        if (boltAddress.isPresent()) {
            AdvertisedSocketAddress advertisedSocketAddress = boltAddress.get();
            if (advertisedSocketAddress.getPort() == 0) {
                int boltPort = this.connectorPortRegister.getLocalAddress("bolt").getPort();
                advertisedSocketAddress = new AdvertisedSocketAddress(advertisedSocketAddress.getHostname(), boltPort);
            }
            if (advertisedSocketAddress.getHostname().equals("localhost")) {
                return this.outputFormat.ok((Representation)new DiscoveryRepresentation(managementUri, dataUri, new AdvertisedSocketAddress(uriInfo.getBaseUri().getHost(), advertisedSocketAddress.getPort())));
            }
            return this.outputFormat.ok((Representation)new DiscoveryRepresentation(managementUri, dataUri, advertisedSocketAddress));
        }
        return this.outputFormat.ok((Representation)new DiscoveryRepresentation(managementUri, dataUri, new AdvertisedSocketAddress(uriInfo.getBaseUri().getHost(), 7687)));
    }

    @GET
    @Produces(value={"*/*"})
    public Response redirectToBrowser() {
        return this.outputFormat.seeOther((URI)this.config.get(ServerSettings.browser_path));
    }
}

