/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.ssl.LegacySslPolicyConfig;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.ScriptExecutionMode;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.time.Clocks;

public class CommunityServerBuilder {
    protected static final ListenSocketAddress ANY_ADDRESS = new ListenSocketAddress("localhost", 0);
    protected final LogProvider logProvider;
    private ListenSocketAddress address = new ListenSocketAddress("localhost", 7474);
    private ListenSocketAddress httpsAddress = new ListenSocketAddress("localhost", 7473);
    private String maxThreads;
    private String dataDir;
    private String managementUri = "/db/manage/";
    private String restUri = "/db/data/";
    private PreFlightTasks preflightTasks;
    private final HashMap<String, String> thirdPartyPackages = new HashMap();
    private final Properties arbitraryProperties = new Properties();
    private static LifecycleManagingDatabase.GraphFactory IN_MEMORY_DB;
    private Clock clock;
    private String[] autoIndexedNodeKeys;
    private final String[] autoIndexedRelationshipKeys = null;
    private String[] securityRuleClassNames;
    private boolean persistent;
    private boolean httpsEnabled;

    public static CommunityServerBuilder server(LogProvider logProvider) {
        return new CommunityServerBuilder(logProvider);
    }

    public static CommunityServerBuilder server() {
        return new CommunityServerBuilder((LogProvider)NullLogProvider.getInstance());
    }

    public static CommunityServerBuilder serverOnRandomPorts() {
        return CommunityServerBuilder.server().onRandomPorts();
    }

    public CommunityNeoServer build() throws IOException {
        if (this.dataDir == null && this.persistent) {
            throw new IllegalStateException("Must specify path");
        }
        File configFile = this.buildBefore();
        Log log = this.logProvider.getLog(this.getClass());
        Config config = Config.fromFile((File)configFile).withServerDefaults().build();
        config.setLogger(log);
        return this.build(configFile, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider(this.logProvider).monitors(new Monitors()));
    }

    protected CommunityNeoServer build(File configFile, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestCommunityNeoServer(config, configFile, dependencies, this.logProvider);
    }

    public File createConfigFiles() throws IOException {
        File temporaryConfigFile = ServerTestUtils.createTempConfigFile();
        File temporaryFolder = ServerTestUtils.createTempDir();
        ServerTestUtils.writeConfigToFile(this.createConfiguration(temporaryFolder), temporaryConfigFile);
        return temporaryConfigFile;
    }

    public CommunityServerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public Map<String, String> createConfiguration(File temporaryFolder) {
        String propertyKeys;
        Map properties = MapUtil.stringMap((String[])new String[]{ServerSettings.management_api_path.name(), this.managementUri, ServerSettings.rest_api_path.name(), this.restUri});
        ServerTestUtils.addDefaultRelativeProperties(properties, temporaryFolder);
        if (this.dataDir != null) {
            properties.put(DatabaseManagementSystemSettings.data_directory.name(), this.dataDir);
        }
        if (this.maxThreads != null) {
            properties.put(ServerSettings.webserver_max_threads.name(), this.maxThreads);
        }
        if (this.thirdPartyPackages.keySet().size() > 0) {
            properties.put(ServerSettings.third_party_packages.name(), ServerTestUtils.asOneLine(this.thirdPartyPackages));
        }
        if (this.autoIndexedNodeKeys != null && this.autoIndexedNodeKeys.length > 0) {
            properties.put("dbms.auto_index.nodes.enabled", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedNodeKeys, (String)",");
            properties.put("dbms.auto_index.nodes.keys", propertyKeys);
        }
        if (this.autoIndexedRelationshipKeys != null && this.autoIndexedRelationshipKeys.length > 0) {
            properties.put("dbms.auto_index.relationships.enabled", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedRelationshipKeys, (String)",");
            properties.put("dbms.auto_index.relationships.keys", propertyKeys);
        }
        if (this.securityRuleClassNames != null && this.securityRuleClassNames.length > 0) {
            propertyKeys = StringUtils.join((Object[])this.securityRuleClassNames, (String)",");
            properties.put(ServerSettings.security_rules.name(), propertyKeys);
        }
        HttpConnector httpConnector = new HttpConnector("http", HttpConnector.Encryption.NONE);
        HttpConnector httpsConnector = new HttpConnector("https", HttpConnector.Encryption.TLS);
        properties.put(httpConnector.type.name(), "HTTP");
        properties.put(httpConnector.enabled.name(), "true");
        properties.put(httpConnector.address.name(), this.address.toString());
        properties.put(httpConnector.encryption.name(), "NONE");
        properties.put(httpsConnector.type.name(), "HTTP");
        properties.put(httpsConnector.enabled.name(), String.valueOf(this.httpsEnabled));
        properties.put(httpsConnector.address.name(), this.httpsAddress.toString());
        properties.put(httpsConnector.encryption.name(), "TLS");
        properties.put(GraphDatabaseSettings.auth_enabled.name(), "false");
        properties.put(LegacySslPolicyConfig.certificates_directory.name(), new File(temporaryFolder, "certificates").getAbsolutePath());
        properties.put(GraphDatabaseSettings.logs_directory.name(), new File(temporaryFolder, "logs").getAbsolutePath());
        properties.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        for (Object key : this.arbitraryProperties.keySet()) {
            properties.put(String.valueOf(key), String.valueOf(this.arbitraryProperties.get(key)));
        }
        return properties;
    }

    protected CommunityServerBuilder(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public CommunityServerBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public CommunityServerBuilder withMaxJettyThreads(int maxThreads) {
        this.maxThreads = String.valueOf(maxThreads);
        return this;
    }

    public CommunityServerBuilder usingDataDir(String dataDir) {
        this.dataDir = dataDir;
        return this;
    }

    public CommunityServerBuilder withRelativeManagementApiUriPath(String uri) {
        try {
            URI theUri = new URI(uri);
            this.managementUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withRelativeRestApiUriPath(String uri) {
        try {
            URI theUri = new URI(uri);
            this.restUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withDefaultDatabaseTuning() {
        return this;
    }

    public CommunityServerBuilder withThirdPartyJaxRsPackage(String packageName, String mountPoint) {
        this.thirdPartyPackages.put(packageName, mountPoint);
        return this;
    }

    public CommunityServerBuilder withAutoIndexingEnabledForNodes(String ... keys) {
        this.autoIndexedNodeKeys = keys;
        return this;
    }

    public CommunityServerBuilder onRandomPorts() {
        this.onHttpsAddress(ANY_ADDRESS);
        this.onAddress(ANY_ADDRESS);
        return this;
    }

    public CommunityServerBuilder onAddress(ListenSocketAddress address) {
        this.address = address;
        return this;
    }

    public CommunityServerBuilder onHttpsAddress(ListenSocketAddress address) {
        this.httpsAddress = address;
        return this;
    }

    public CommunityServerBuilder withSecurityRules(String ... securityRuleClassNames) {
        this.securityRuleClassNames = securityRuleClassNames;
        return this;
    }

    public CommunityServerBuilder withHttpsEnabled() {
        this.httpsEnabled = true;
        return this;
    }

    public CommunityServerBuilder withProperty(String key, String value) {
        this.arbitraryProperties.put(key, value);
        return this;
    }

    protected DatabaseActions createDatabaseActionsObject(Database database, Config config) {
        Clock clockToUse = this.clock != null ? this.clock : Clocks.systemClock();
        return new DatabaseActions(new LeaseManager(clockToUse), ScriptExecutionMode.getConfiguredMode((Config)config), (GraphDatabaseAPI)database.getGraph());
    }

    private File buildBefore() throws IOException {
        File configFile = this.createConfigFiles();
        if (this.preflightTasks == null) {
            this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), new PreflightTask[0]){

                public boolean run() {
                    return true;
                }
            };
        }
        return configFile;
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        IN_MEMORY_DB = (config, dependencies) -> {
            File storeDir = (File)config.get(DatabaseManagementSystemSettings.database_path);
            config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseFacadeFactory.Configuration.ephemeral.name(), "true", new BoltConnector((String)"bolt").listen_address.name(), "localhost:0"}));
            return new ImpermanentGraphDatabase(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)dependencies));
        };
    }

    private class TestCommunityNeoServer
    extends CommunityNeoServer {
        private final File configFile;

        private TestCommunityNeoServer(Config config, File configFile, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
            super(config, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)(CommunityServerBuilder.this.persistent ? COMMUNITY_FACTORY : IN_MEMORY_DB)), dependencies, logProvider);
            this.configFile = configFile;
        }

        protected DatabaseActions createDatabaseActions() {
            return CommunityServerBuilder.this.createDatabaseActionsObject(this.database, this.getConfig());
        }

        public void stop() {
            super.stop();
            if (this.configFile != null) {
                this.configFile.delete();
            }
        }
    }
}

