/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.RelationshipDirection;
import org.neo4j.test.server.HTTP;

public class HtmlIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;
    private long thomasAnderson;
    private long trinity;
    private long thomasAndersonLovesTrinity;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(HtmlIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void setupTheDatabase() {
        this.thomasAnderson = this.createAndIndexNode("Thomas Anderson");
        this.trinity = this.createAndIndexNode("Trinity");
        long tank = this.createAndIndexNode("Tank");
        long knowsRelationshipId = helper.createRelationship("KNOWS", this.thomasAnderson, this.trinity);
        this.thomasAndersonLovesTrinity = helper.createRelationship("LOVES", this.thomasAnderson, this.trinity);
        helper.setRelationshipProperties(this.thomasAndersonLovesTrinity, Collections.singletonMap("strength", 100));
        helper.createRelationship("KNOWS", this.thomasAnderson, tank);
        helper.createRelationship("KNOWS", this.trinity, tank);
        helper.createRelationshipIndex("relationships");
        helper.addRelationshipToIndex("relationships", "key", "value", knowsRelationshipId);
        helper.createRelationshipIndex("relationships2");
        helper.addRelationshipToIndex("relationships2", "key2", "value2", knowsRelationshipId);
    }

    private long createAndIndexNode(String name) {
        long id = helper.createNode(new Label[0]);
        helper.setNodeProperties(id, Collections.singletonMap("name", name));
        helper.addNodeToIndex("node", "name", name, id);
        return id;
    }

    @Test
    public void shouldGetRoot() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.dataUri(), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        this.assertValidHtml(response.getEntity());
        response.close();
    }

    @Test
    public void shouldGetRootWithHTTP() {
        HTTP.Response response = HTTP.withHeaders("Accept", "text/html").GET(functionalTestHelper.dataUri());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.status());
        this.assertValidHtml(response.rawContent());
    }

    @Test
    public void shouldGetNodeIndexRoot() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.nodeIndexUri(), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        this.assertValidHtml(response.getEntity());
        response.close();
    }

    @Test
    public void shouldGetRelationshipIndexRoot() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipIndexUri(), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        this.assertValidHtml(response.getEntity());
        response.close();
    }

    @Test
    public void shouldGetTrinityWhenSearchingForHer() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexNodeUri("node", "name", "Trinity"), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = response.getEntity();
        Assert.assertTrue((boolean)entity.contains("Trinity"));
        this.assertValidHtml(entity);
        response.close();
    }

    @Test
    public void shouldGetThomasAndersonDirectly() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.nodeUri(this.thomasAnderson), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = response.getEntity();
        Assert.assertTrue((boolean)entity.contains("Thomas Anderson"));
        this.assertValidHtml(entity);
        response.close();
    }

    @Test
    public void shouldGetSomeRelationships() {
        RestRequest request = RestRequest.req();
        JaxRsResponse response = request.get(functionalTestHelper.relationshipsUri(this.thomasAnderson, RelationshipDirection.all.name(), "KNOWS"), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = response.getEntity();
        Assert.assertTrue((boolean)entity.contains("KNOWS"));
        Assert.assertFalse((boolean)entity.contains("LOVES"));
        this.assertValidHtml(entity);
        response.close();
        response = request.get(functionalTestHelper.relationshipsUri(this.thomasAnderson, RelationshipDirection.all.name(), "LOVES"), MediaType.TEXT_HTML_TYPE);
        entity = response.getEntity();
        Assert.assertFalse((boolean)entity.contains("KNOWS"));
        Assert.assertTrue((boolean)entity.contains("LOVES"));
        this.assertValidHtml(entity);
        response.close();
        response = request.get(functionalTestHelper.relationshipsUri(this.thomasAnderson, RelationshipDirection.all.name(), "LOVES", "KNOWS"), MediaType.TEXT_HTML_TYPE);
        entity = response.getEntity();
        Assert.assertTrue((boolean)entity.contains("KNOWS"));
        Assert.assertTrue((boolean)entity.contains("LOVES"));
        this.assertValidHtml(entity);
        response.close();
    }

    @Test
    public void shouldGetThomasAndersonLovesTrinityRelationship() {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipUri(this.thomasAndersonLovesTrinity), MediaType.TEXT_HTML_TYPE);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String entity = response.getEntity();
        Assert.assertTrue((boolean)entity.contains("strength"));
        Assert.assertTrue((boolean)entity.contains("100"));
        Assert.assertTrue((boolean)entity.contains("LOVES"));
        this.assertValidHtml(entity);
        response.close();
    }

    private void assertValidHtml(String entity) {
        Assert.assertTrue((boolean)entity.contains("<html>"));
        Assert.assertTrue((boolean)entity.contains("</html>"));
    }
}

