/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.rest.dbms.UserService;
import org.neo4j.server.web.WebServer;
import org.neo4j.test.rule.SuppressOutput;

public class DBMSModuleTest {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.err, SuppressOutput.System.out});

    @Test
    public void shouldRegisterAtRootByDefault() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        Config config = (Config)Mockito.mock(Config.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)config.get(GraphDatabaseSettings.auth_enabled)).thenReturn((Object)true);
        DBMSModule module = new DBMSModule(webServer, config);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(Matchers.anyList(), Matchers.anyString(), Matchers.anyCollection());
    }

    @Test
    public void shouldNotRegisterUserServiceWhenAuthDisabled() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        Config config = (Config)Mockito.mock(Config.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)config.get(GraphDatabaseSettings.auth_enabled)).thenReturn((Object)false);
        DBMSModule module = new DBMSModule(webServer, config);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSClasses(Matchers.anyList(), Matchers.anyString(), Matchers.anyCollection());
        ((WebServer)Mockito.verify((Object)webServer, (VerificationMode)Mockito.never())).addJAXRSClasses((List)Matchers.argThat((Matcher)new ArgumentMatcher<List<String>>(){

            public boolean matches(Object argument) {
                List argumentList = (List)argument;
                return argumentList.contains(UserService.class.getName());
            }

            public void describeTo(Description description) {
                description.appendText("<List containing " + UserService.class.getName() + ">");
            }
        }), Matchers.anyString(), Matchers.anyCollection());
    }
}

