/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.GraphDbHelper;

public class XForwardFilterIT
extends AbstractRestFunctionalTestBase {
    public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
    public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private Client client = Client.create();
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(XForwardFilterIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void setupTheDatabase() {
        helper.createRelationship("RELATES_TO", helper.createNode(new Label[0]), helper.createNode(new Label[0]));
    }

    @Test
    public void shouldUseXForwardedHostHeaderWhenPresent() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldUseXForwardedProtoHeaderWhenPresent() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_PROTO, (Object)"https")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("https://localhost"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldPickFirstXForwardedHostHeaderValueFromCommaOrCommaAndSpaceSeparatedList() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org, kathwebber.com,neo4j.org")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("http://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains("http://localhost"));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedHostHeader() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)":bad_URI")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains(this.getServerUri()));
    }

    @Test
    public void shouldUseBaseUriIfFirstAddressInXForwardedHostHeaderIsBad() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)":bad_URI,good-host")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains(this.getServerUri()));
    }

    @Test
    public void shouldUseBaseUriOnBadXForwardedProtoHeader() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_PROTO, (Object)"%%%DEFINITELY-NOT-A-PROTO!")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains(this.getServerUri()));
    }

    @Test
    public void shouldUseXForwardedHostAndXForwardedProtoHeadersWhenPresent() throws Exception {
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.client.resource(this.getManageUri()).accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org")).header(X_FORWARDED_PROTO, (Object)"https")).get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("https://jimwebber.org"));
        Assert.assertFalse((boolean)entity.contains(this.getServerUri()));
    }

    @Test
    public void shouldUseXForwardedHostAndXForwardedProtoHeadersInCypherResponseRepresentations() {
        String jsonString = "{\"statements\" : [{ \"statement\": \"MATCH (n) RETURN n\", \"resultDataContents\":[\"REST\"] }] }";
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)this.client.resource(this.getServerUri() + "db/data/transaction").accept(new String[]{"application/json"}).header(X_FORWARDED_HOST, (Object)"jimwebber.org:2354")).header(X_FORWARDED_PROTO, (Object)"https")).entity((Object)jsonString, MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        Assert.assertTrue((boolean)entity.contains("https://jimwebber.org:2354"));
        Assert.assertFalse((boolean)entity.contains(this.getServerUri()));
    }

    private String getManageUri() {
        return this.getServerUri() + "db/manage";
    }

    private String getServerUri() {
        return XForwardFilterIT.server().baseUri().toString();
    }
}

