/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class UsersIT
extends ExclusiveServerTestBase {
    @Rule
    public TestData<RESTRequestGenerator> gen = TestData.producedThrough(RESTRequestGenerator.PRODUCER);
    private CommunityNeoServer server;

    @Test
    @Documented(value="User status\n\nGiven that you know the current password, you can ask the server for the user status.")
    public void user_status() throws JsonParseException, IOException {
        this.startServerWithConfiguredUser();
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).withHeader("Authorization", this.challengeResponse("neo4j", "secret")).get(this.userURL("neo4j"));
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("username").asText(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
        Assert.assertThat((Object)data.get("password_change_required").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)data.get("password_change").asText(), (Matcher)CoreMatchers.equalTo((Object)this.passwordURL("neo4j")));
    }

    @Test
    @Documented(value="User status on first access\n\nOn first access, and using the default password, the user status will indicate that the users password requires changing.")
    public void user_status_first_access() throws JsonParseException, IOException {
        this.startServer(true);
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).withHeader("Authorization", this.challengeResponse("neo4j", "neo4j")).get(this.userURL("neo4j"));
        JsonNode data = JsonHelper.jsonNode((String)response.entity());
        Assert.assertThat((Object)data.get("username").asText(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
        Assert.assertThat((Object)data.get("password_change_required").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)data.get("password_change").asText(), (Matcher)CoreMatchers.equalTo((Object)this.passwordURL("neo4j")));
    }

    @Test
    @Documented(value="Changing the user password\n\nGiven that you know the current password, you can ask the server to change a users password. You can choose any\npassword you like, as long as it is different from the current password.")
    public void change_password() throws JsonParseException, IOException {
        this.startServer(true);
        RESTRequestGenerator.ResponseEntity response = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).withHeader("Authorization", this.challengeResponse("neo4j", "neo4j")).payload(this.quotedJson("{'password':'secret'}")).post(this.server.baseUri().resolve("/user/neo4j/password").toString());
        Assert.assertEquals((long)200L, (long)HTTP.withHeaders("Authorization", this.challengeResponse("neo4j", "secret")).GET(this.dataURL()).status());
        Assert.assertEquals((long)401L, (long)HTTP.withHeaders("Authorization", this.challengeResponse("neo4j", "neo4j")).POST(this.dataURL()).status());
    }

    @Test
    public void cantChangeToCurrentPassword() throws Exception {
        this.startServer(true);
        HTTP.Response res = HTTP.withHeaders("Authorization", this.challengeResponse("neo4j", "neo4j")).POST(this.server.baseUri().resolve("/user/neo4j/password").toString(), HTTP.RawPayload.quotedJson("{'password':'neo4j'}"));
        Assert.assertThat((Object)res.status(), (Matcher)CoreMatchers.equalTo((Object)422));
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void startServer(boolean authEnabled) throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).build();
        this.server.start();
    }

    public void startServerWithConfiguredUser() throws IOException {
        this.startServer(true);
        HTTP.Response post = HTTP.withHeaders("Authorization", this.challengeResponse("neo4j", "neo4j")).POST(this.server.baseUri().resolve("/user/neo4j/password").toString(), HTTP.RawPayload.quotedJson("{'password':'secret'}"));
        Assert.assertEquals((long)200L, (long)post.status());
    }

    private String challengeResponse(String username, String password) {
        return "Basic " + this.base64(username + ":" + password);
    }

    private String dataURL() {
        return this.server.baseUri().resolve("db/data/").toString();
    }

    private String userURL(String username) {
        return this.server.baseUri().resolve("user/" + username).toString();
    }

    private String passwordURL(String username) {
        return this.server.baseUri().resolve("user/" + username + "/password").toString();
    }

    private String base64(String value) {
        return UTF8.decode((byte[])Base64.encode((String)value));
    }

    private String quotedJson(String singleQuoted) {
        return singleQuoted.replaceAll("'", "\"");
    }
}

