/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.ArrayList;
import org.neo4j.server.helpers.PropertyTypeDispatcher;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.ValueRepresentation;

public abstract class RepresentationDispatcher
extends PropertyTypeDispatcher<String, Representation> {
    protected Representation dispatchBooleanProperty(boolean property, String param) {
        return ValueRepresentation.bool((boolean)property);
    }

    protected Representation dispatchDoubleProperty(double property, String param) {
        return ValueRepresentation.number((double)property);
    }

    protected Representation dispatchFloatProperty(float property, String param) {
        return ValueRepresentation.number((double)property);
    }

    protected Representation dispatchIntegerProperty(int property, String param) {
        return ValueRepresentation.number((int)property);
    }

    protected Representation dispatchLongProperty(long property, String param) {
        return ValueRepresentation.number((long)property);
    }

    protected Representation dispatchShortProperty(short property, String param) {
        return ValueRepresentation.number((int)property);
    }

    protected Representation dispatchStringProperty(String property, String param) {
        return ValueRepresentation.string((String)property);
    }

    protected Representation dispatchStringArrayProperty(String[] array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (String z : array) {
            values.add(ValueRepresentation.string((String)z));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchShortArrayProperty(PropertyTypeDispatcher.PropertyArray<short[], Short> array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (Short z : array) {
            values.add(ValueRepresentation.number((int)z.shortValue()));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchIntegerArrayProperty(PropertyTypeDispatcher.PropertyArray<int[], Integer> array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (Integer z : array) {
            values.add(ValueRepresentation.number((int)z));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchLongArrayProperty(PropertyTypeDispatcher.PropertyArray<long[], Long> array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (Long z : array) {
            values.add(ValueRepresentation.number((long)z));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchFloatArrayProperty(PropertyTypeDispatcher.PropertyArray<float[], Float> array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (Float z : array) {
            values.add(ValueRepresentation.number((double)z.floatValue()));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchDoubleArrayProperty(PropertyTypeDispatcher.PropertyArray<double[], Double> array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (Double z : array) {
            values.add(ValueRepresentation.number((double)z));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchBooleanArrayProperty(PropertyTypeDispatcher.PropertyArray<boolean[], Boolean> array, String param) {
        ArrayList<ValueRepresentation> values = new ArrayList<ValueRepresentation>();
        for (Boolean z : array) {
            values.add(ValueRepresentation.bool((boolean)z));
        }
        return new ListRepresentation("", values);
    }

    protected Representation dispatchByteProperty(byte property, String param) {
        throw new UnsupportedOperationException("Representing bytes not implemented.");
    }

    protected Representation dispatchCharacterProperty(char property, String param) {
        return ValueRepresentation.number((int)property);
    }
}

