/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.integration;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class StartupLoggingIT
extends ExclusiveServerTestBase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TestDirectory homeDir = TestDirectory.testDirectory();

    @Before
    public void setUp() throws IOException {
        FileUtils.deleteRecursively((File)ServerTestUtils.getRelativeFile((Setting<File>)GraphDatabaseSettings.data_directory));
    }

    @Test
    public void shouldLogHelpfulStartupMessages() throws Throwable {
        CommunityBootstrapper boot = new CommunityBootstrapper();
        Map<String, String> propertyPairs = this.getPropertyPairs();
        boot.start(this.homeDir.directory(), Optional.of(new File("nonexistent-file.conf")), propertyPairs);
        URI uri = boot.getServer().baseUri();
        boot.stop();
        List captured = this.suppressOutput.getOutputVoice().lines();
        MatcherAssert.assertThat((Object)captured, StartupLoggingIT.containsAtLeastTheseLines(StartupLoggingIT.warn("Config file \\[nonexistent-file.conf\\] does not exist."), StartupLoggingIT.info(AbstractNeoServer.NEO4J_IS_STARTING_MESSAGE), StartupLoggingIT.info("Starting..."), StartupLoggingIT.info("Started."), StartupLoggingIT.info("Remote interface available at " + uri.toString()), StartupLoggingIT.info("Stopping..."), StartupLoggingIT.info("Stopped.")));
    }

    private Map<String, String> getPropertyPairs() throws IOException {
        Map<String, String> relativeProperties = ServerTestUtils.getDefaultRelativeProperties();
        relativeProperties.put(GraphDatabaseSettings.allow_upgrade.name(), "true");
        HttpConnector http = new HttpConnector("http", HttpConnector.Encryption.NONE);
        relativeProperties.put(http.type.name(), "HTTP");
        relativeProperties.put(http.listen_address.name(), "localhost:" + PortAuthority.allocatePort());
        relativeProperties.put(http.enabled.name(), "true");
        HttpConnector https = new HttpConnector("https", HttpConnector.Encryption.TLS);
        relativeProperties.put(https.type.name(), "HTTP");
        relativeProperties.put(https.listen_address.name(), "localhost:" + PortAuthority.allocatePort());
        relativeProperties.put(https.enabled.name(), "true");
        BoltConnector bolt = new BoltConnector("bolt");
        relativeProperties.put(bolt.type.name(), "BOLT");
        relativeProperties.put(bolt.enabled.name(), "true");
        relativeProperties.put(bolt.listen_address.name(), "localhost:" + PortAuthority.allocatePort());
        relativeProperties.put(GraphDatabaseSettings.database_path.name(), this.homeDir.absolutePath().getAbsolutePath());
        return relativeProperties;
    }

    @SafeVarargs
    private static Matcher<List<String>> containsAtLeastTheseLines(final Matcher<String> ... expectedLinePatterns) {
        return new TypeSafeMatcher<List<String>>(){

            protected boolean matchesSafely(List<String> lines) {
                if (expectedLinePatterns.length > lines.size()) {
                    return false;
                }
                int e = 0;
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    while (!expectedLinePatterns[e].matches((Object)line)) {
                        if (++i >= lines.size()) {
                            return false;
                        }
                        line = lines.get(i);
                    }
                    ++e;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("", "\n", "", Arrays.asList(expectedLinePatterns));
            }
        };
    }

    public static Matcher<String> info(String messagePattern) {
        return StartupLoggingIT.line("INFO", messagePattern);
    }

    public static Matcher<String> warn(String messagePattern) {
        return StartupLoggingIT.line("WARN", messagePattern);
    }

    public static Matcher<String> line(final String level, final String messagePattern) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String line) {
                return line.matches(".*" + level + "\\s+" + messagePattern);
            }

            public void describeTo(Description description) {
                description.appendText(level).appendText(" ").appendText(messagePattern);
            }
        };
    }
}

