/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.TxStateCheckerTestSupport;

public class Neo4jJsonCodecTest
extends TxStateCheckerTestSupport {
    private Neo4jJsonCodec jsonCodec;
    private JsonGenerator jsonGenerator;

    @Before
    public void init() throws IOException {
        this.jsonCodec = new Neo4jJsonCodec(TPTPMC);
        this.jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
    }

    @Test
    public void testPropertyContainerWriting() throws IOException {
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)propertyContainer.getAllProperties()).thenThrow(RuntimeException.class);
        boolean exceptionThrown = false;
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)propertyContainer);
        }
        catch (IllegalArgumentException e) {
            ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)0))).writeEndObject();
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testNodeWriting() throws IOException {
        PropertyContainer node = (PropertyContainer)Mockito.mock(Node.class);
        Mockito.when((Object)node.getAllProperties()).thenThrow(RuntimeException.class);
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)node);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void testRelationshipWriting() throws IOException {
        PropertyContainer relationship = (PropertyContainer)Mockito.mock(Relationship.class);
        Mockito.when((Object)relationship.getAllProperties()).thenThrow(RuntimeException.class);
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)relationship);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void testPathWriting() throws IOException {
        Path path = (Path)Mockito.mock(Path.class);
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)propertyContainer.getAllProperties()).thenThrow(RuntimeException.class);
        Mockito.when((Object)path.iterator()).thenReturn(Arrays.asList(propertyContainer).listIterator());
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testIteratorWriting() throws IOException {
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)propertyContainer.getAllProperties()).thenThrow(RuntimeException.class);
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, Arrays.asList(propertyContainer));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testByteArrayWriting() throws IOException {
        ((JsonGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.jsonGenerator)).writeNumber(ArgumentMatchers.anyInt());
        byte[] byteArray = new byte[]{1, 2, 3};
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)byteArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testMapWriting() throws IOException {
        ((JsonGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.jsonGenerator)).writeFieldName(ArgumentMatchers.anyString());
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void shouldWriteAMapContainingNullAsKeysAndValues() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(null, null);
        this.jsonCodec.writeValue(this.jsonGenerator, map);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeFieldName("null");
    }

    @Test
    public void testGeographicPointWriting() throws IOException {
        MockPoint value = new MockPoint(12.3, 45.6, Neo4jJsonCodecTest.mockWGS84());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    public void testCartesianPointWriting() throws IOException {
        MockPoint value = new MockPoint(123.0, 456.0, Neo4jJsonCodecTest.mockCartesian());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    public void testGeometryWriting() throws IOException {
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        points.add(new Coordinate(new double[]{1.0, 2.0}));
        points.add(new Coordinate(new double[]{2.0, 3.0}));
        MockGeometry value = new MockGeometry("LineString", points, Neo4jJsonCodecTest.mockCartesian());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    public static CRS mockWGS84() {
        return Neo4jJsonCodecTest.mockCRS(4326, "WGS-84", "http://spatialreference.org/ref/epsg/4326/");
    }

    public static CRS mockCartesian() {
        return Neo4jJsonCodecTest.mockCRS(7203, "cartesian", "http://spatialreference.org/ref/sr-org/7203/");
    }

    public static CRS mockCRS(final int code, final String type, final String href) {
        return new CRS(){

            public int getCode() {
                return code;
            }

            public String getType() {
                return type;
            }

            public String getHref() {
                return href;
            }
        };
    }

    public static class MockGeometry
    implements Geometry {
        protected final String geometryType;
        protected final CRS crs;
        protected final List<Coordinate> coordinates;

        public MockGeometry(String geometryType, List<Coordinate> coordinates, CRS crs) {
            this.geometryType = geometryType;
            this.coordinates = coordinates;
            this.crs = crs;
        }

        public String getGeometryType() {
            return this.geometryType;
        }

        public List<Coordinate> getCoordinates() {
            return this.coordinates;
        }

        public CRS getCRS() {
            return this.crs;
        }
    }

    public static class MockPoint
    extends MockGeometry
    implements Point {
        private final Coordinate coordinate;

        public MockPoint(double x, double y, CRS crs) {
            super("Point", new ArrayList<Coordinate>(), crs);
            this.coordinate = new Coordinate(new double[]{x, y});
            this.coordinates.add(this.coordinate);
        }
    }
}

