/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.web.HttpConnectionInfoFactory;

public class TransitionalPeriodTransactionMessContainer {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final GraphDatabaseFacade db;
    private final ThreadToStatementContextBridge txBridge;

    public TransitionalPeriodTransactionMessContainer(GraphDatabaseFacade db) {
        this.db = db;
        this.txBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }

    public TransitionalTxManagementKernelTransaction newTransaction(Transaction.Type type, SecurityContext securityContext, long customTransactionTimeout) {
        return new TransitionalTxManagementKernelTransaction(this.db, type, securityContext, customTransactionTimeout, this.txBridge);
    }

    ThreadToStatementContextBridge getBridge() {
        return this.txBridge;
    }

    public TransactionalContext create(HttpServletRequest request, GraphDatabaseQueryService service, Transaction.Type type, SecurityContext securityContext, String query, Map<String, Object> queryParameters) {
        TransactionalContextFactory contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)service, (PropertyContainerLocker)locker);
        ClientConnectionInfo clientConnection = HttpConnectionInfoFactory.create(request);
        InternalTransaction transaction = service.beginTransaction(type, securityContext);
        return contextFactory.newContext(clientConnection, transaction, query, ValueUtils.asMapValue(queryParameters));
    }
}

