/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.scripting.javascript.JavascriptExecutor;

public class TestJavascriptExecutor {
    @Test
    public void shouldExecuteBasicScript() throws Exception {
        JavascriptExecutor executor = new JavascriptExecutor("1337;");
        Object out = executor.execute(null);
        Assert.assertThat((Object)out, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)out, (Matcher)Matchers.is((Object)1337));
    }

    @Test
    public void shouldAllowContextVariables() throws Exception {
        JavascriptExecutor executor = new JavascriptExecutor("myVar;");
        HashMap<String, Integer> ctx = new HashMap<String, Integer>();
        ctx.put("myVar", 1338);
        Object out = executor.execute(ctx);
        Assert.assertThat((Object)out, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)out, (Matcher)Matchers.is((Object)1338));
    }

    @Test
    public void shouldBeAbleToReuseExecutor() throws Exception {
        JavascriptExecutor executor = new JavascriptExecutor("1337;");
        Object out1 = executor.execute(null);
        Object out2 = executor.execute(null);
        Assert.assertThat((Object)out1, (Matcher)Matchers.is((Object)1337));
        Assert.assertThat((Object)out2, (Matcher)Matchers.is((Object)1337));
    }

    @Test
    public void varsSetInOneExecutionShouldNotBeAvailableInAnother() throws Exception {
        JavascriptExecutor executor = new JavascriptExecutor("if(firstRun) {   this['theVar'] = 'boo'; } else {   this['theVar']; }");
        HashMap<String, Boolean> ctx = new HashMap<String, Boolean>();
        ctx.put("firstRun", true);
        Object out1 = executor.execute(ctx);
        ctx.put("firstRun", false);
        Object out2 = executor.execute(ctx);
        Assert.assertThat((Object)out1, (Matcher)Matchers.is((Object)"boo"));
        Assert.assertThat((Object)out2, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

