/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import com.sun.jersey.api.core.HttpContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.search.Sort;
import org.neo4j.function.Predicates;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.rest.domain.EndNodeNotFoundException;
import org.neo4j.server.rest.domain.PropertySettingStrategy;
import org.neo4j.server.rest.domain.RelationshipExpanderBuilder;
import org.neo4j.server.rest.domain.StartNodeNotFoundException;
import org.neo4j.server.rest.domain.TraversalDescriptionBuilder;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.paging.Lease;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.paging.PagedTraverser;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.ConstraintDefinitionRepresentation;
import org.neo4j.server.rest.repr.DatabaseRepresentation;
import org.neo4j.server.rest.repr.IndexDefinitionRepresentation;
import org.neo4j.server.rest.repr.IndexRepresentation;
import org.neo4j.server.rest.repr.IndexedEntityRepresentation;
import org.neo4j.server.rest.repr.InvalidArgumentsException;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeIndexRepresentation;
import org.neo4j.server.rest.repr.NodeIndexRootRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.PropertiesRepresentation;
import org.neo4j.server.rest.repr.RelationshipIndexRepresentation;
import org.neo4j.server.rest.repr.RelationshipIndexRootRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ScoredNodeRepresentation;
import org.neo4j.server.rest.repr.ScoredRelationshipRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.WeightedPathRepresentation;
import org.neo4j.server.rest.web.NoSuchPropertyException;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;

public class DatabaseActions {
    public static final String SCORE_ORDER = "score";
    public static final String RELEVANCE_ORDER = "relevance";
    public static final String INDEX_ORDER = "index";
    private final GraphDatabaseAPI graphDb;
    private final LeaseManager leases;
    private final TraversalDescriptionBuilder traversalDescriptionBuilder;
    private final PropertySettingStrategy propertySetter;
    private final Function<ConstraintDefinition, Representation> CONSTRAINT_DEF_TO_REPRESENTATION = ConstraintDefinitionRepresentation::new;
    private static final PathRepresentationCreator<Path> PATH_REPRESENTATION_CREATOR = path -> new PathRepresentation<Path>(path);
    private static final PathRepresentationCreator<WeightedPath> WEIGHTED_PATH_REPRESENTATION_CREATOR = path -> new WeightedPathRepresentation((WeightedPath)path);

    public DatabaseActions(LeaseManager leaseManager, boolean enableScriptSandboxing, GraphDatabaseAPI graphDatabaseAPI) {
        this.leases = leaseManager;
        this.graphDb = graphDatabaseAPI;
        this.traversalDescriptionBuilder = new TraversalDescriptionBuilder(enableScriptSandboxing);
        this.propertySetter = new PropertySettingStrategy(this.graphDb);
    }

    public DatabaseActions(LeaseManager leaseManager, GraphDatabaseAPI graphDatabaseAPI) {
        this(leaseManager, true, graphDatabaseAPI);
    }

    private Node node(long id) throws NodeNotFoundException {
        try {
            return this.graphDb.getNodeById(id);
        }
        catch (NotFoundException e) {
            throw new NodeNotFoundException(String.format("Cannot find node with id [%d] in database.", id), e);
        }
    }

    private Relationship relationship(long id) throws RelationshipNotFoundException {
        try {
            return this.graphDb.getRelationshipById(id);
        }
        catch (NotFoundException e) {
            throw new RelationshipNotFoundException((Throwable)e);
        }
    }

    public DatabaseRepresentation root() {
        return new DatabaseRepresentation();
    }

    public NodeRepresentation createNode(Map<String, Object> properties, Label ... labels) throws PropertyValueException {
        Node node = this.graphDb.createNode();
        this.propertySetter.setProperties((PropertyContainer)node, properties);
        if (labels != null) {
            for (Label label : labels) {
                node.addLabel(label);
            }
        }
        return new NodeRepresentation(node);
    }

    public NodeRepresentation getNode(long nodeId) throws NodeNotFoundException {
        return new NodeRepresentation(this.node(nodeId));
    }

    public void deleteNode(long nodeId) throws NodeNotFoundException, ConstraintViolationException {
        Node node = this.node(nodeId);
        if (node.hasRelationship()) {
            throw new ConstraintViolationException(String.format("The node with id %d cannot be deleted. Check that the node is orphaned before deletion.", nodeId));
        }
        node.delete();
    }

    public Representation getAllPropertyKeys() {
        Set propKeys = Iterables.asSet((Iterable)Iterables.map(key -> ValueRepresentation.string((String)key), (Iterable)this.graphDb.getAllPropertyKeys()));
        return new ListRepresentation(RepresentationType.STRING, (Iterable)propKeys);
    }

    public Representation getNodeProperty(long nodeId, String key) throws NodeNotFoundException, NoSuchPropertyException {
        Node node = this.node(nodeId);
        try {
            return PropertiesRepresentation.value(node.getProperty(key));
        }
        catch (NotFoundException e) {
            throw new NoSuchPropertyException((PropertyContainer)node, key);
        }
    }

    public void setNodeProperty(long nodeId, String key, Object value) throws PropertyValueException, NodeNotFoundException {
        Node node = this.node(nodeId);
        this.propertySetter.setProperty((PropertyContainer)node, key, value);
    }

    public void removeNodeProperty(long nodeId, String key) throws NodeNotFoundException, NoSuchPropertyException {
        Node node = this.node(nodeId);
        if (node.removeProperty(key) == null) {
            throw new NoSuchPropertyException((PropertyContainer)node, key);
        }
    }

    public PropertiesRepresentation getAllNodeProperties(long nodeId) throws NodeNotFoundException {
        return new PropertiesRepresentation((PropertyContainer)this.node(nodeId));
    }

    public void setAllNodeProperties(long nodeId, Map<String, Object> properties) throws PropertyValueException, NodeNotFoundException {
        this.propertySetter.setAllProperties((PropertyContainer)this.node(nodeId), properties);
    }

    public void removeAllNodeProperties(long nodeId) throws NodeNotFoundException, PropertyValueException {
        this.propertySetter.setAllProperties((PropertyContainer)this.node(nodeId), null);
    }

    public void addLabelToNode(long nodeId, Collection<String> labelNames) throws NodeNotFoundException, BadInputException {
        try {
            Node node = this.node(nodeId);
            for (String labelName : labelNames) {
                node.addLabel(Label.label((String)labelName));
            }
        }
        catch (ConstraintViolationException e) {
            throw new BadInputException("Unable to add label, see nested exception.", (Throwable)e);
        }
    }

    public void setLabelsOnNode(long nodeId, Collection<String> labels) throws NodeNotFoundException, BadInputException {
        Node node = this.node(nodeId);
        try {
            for (Label label : node.getLabels()) {
                node.removeLabel(label);
            }
            for (String labelName : labels) {
                node.addLabel(Label.label((String)labelName));
            }
        }
        catch (ConstraintViolationException e) {
            throw new BadInputException("Unable to add label, see nested exception.", (Throwable)e);
        }
    }

    public void removeLabelFromNode(long nodeId, String labelName) throws NodeNotFoundException {
        this.node(nodeId).removeLabel(Label.label((String)labelName));
    }

    public ListRepresentation getNodeLabels(long nodeId) throws NodeNotFoundException {
        IterableWrapper<String, Label> labels = new IterableWrapper<String, Label>(this.node(nodeId).getLabels()){

            protected String underlyingObjectToObject(Label object) {
                return object.name();
            }
        };
        return ListRepresentation.string((Iterable)labels);
    }

    public String[] getNodeIndexNames() {
        return this.graphDb.index().nodeIndexNames();
    }

    public String[] getRelationshipIndexNames() {
        return this.graphDb.index().relationshipIndexNames();
    }

    public IndexRepresentation createNodeIndex(Map<String, Object> indexSpecification) {
        String indexName = (String)indexSpecification.get("name");
        this.assertIsLegalIndexName(indexName);
        if (indexSpecification.containsKey("config")) {
            Map config = (Map)indexSpecification.get("config");
            this.graphDb.index().forNodes(indexName, config);
            return new NodeIndexRepresentation(indexName, config);
        }
        this.graphDb.index().forNodes(indexName);
        return new NodeIndexRepresentation(indexName, Collections.emptyMap());
    }

    public IndexRepresentation createRelationshipIndex(Map<String, Object> indexSpecification) {
        String indexName = (String)indexSpecification.get("name");
        this.assertIsLegalIndexName(indexName);
        if (indexSpecification.containsKey("config")) {
            Map config = (Map)indexSpecification.get("config");
            this.graphDb.index().forRelationships(indexName, config);
            return new RelationshipIndexRepresentation(indexName, config);
        }
        this.graphDb.index().forRelationships(indexName);
        return new RelationshipIndexRepresentation(indexName, Collections.emptyMap());
    }

    public void removeNodeIndex(String indexName) {
        if (!this.graphDb.index().existsForNodes(indexName)) {
            throw new NotFoundException("No node index named '" + indexName + "'.");
        }
        this.graphDb.index().forNodes(indexName).delete();
    }

    public void removeRelationshipIndex(String indexName) {
        if (!this.graphDb.index().existsForRelationships(indexName)) {
            throw new NotFoundException("No relationship index named '" + indexName + "'.");
        }
        this.graphDb.index().forRelationships(indexName).delete();
    }

    public boolean nodeIsIndexed(String indexName, String key, Object value, long nodeId) {
        Index index = this.graphDb.index().forNodes(indexName);
        Node expectedNode = this.graphDb.getNodeById(nodeId);
        try (IndexHits hits = index.get(key, value);){
            boolean bl = this.iterableContains((Iterable)hits, (Object)expectedNode);
            return bl;
        }
    }

    public boolean relationshipIsIndexed(String indexName, String key, Object value, long relationshipId) {
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        Relationship expectedNode = this.graphDb.getRelationshipById(relationshipId);
        try (IndexHits hits = index.get(key, value);){
            boolean bl = this.iterableContains((Iterable)hits, (Object)expectedNode);
            return bl;
        }
    }

    private <T> boolean iterableContains(Iterable<T> iterable, T expectedElement) {
        for (T possibleMatch : iterable) {
            if (!possibleMatch.equals(expectedElement)) continue;
            return true;
        }
        return false;
    }

    public Representation isAutoIndexerEnabled(String type) {
        AutoIndexer<? extends PropertyContainer> index = this.getAutoIndexerForType(type);
        return ValueRepresentation.bool((boolean)index.isEnabled());
    }

    public void setAutoIndexerEnabled(String type, boolean enable) {
        AutoIndexer<? extends PropertyContainer> index = this.getAutoIndexerForType(type);
        index.setEnabled(enable);
    }

    private AutoIndexer<? extends PropertyContainer> getAutoIndexerForType(String type) {
        IndexManager indexManager = this.graphDb.index();
        switch (type) {
            case "node": {
                return indexManager.getNodeAutoIndexer();
            }
            case "relationship": {
                return indexManager.getRelationshipAutoIndexer();
            }
        }
        throw new IllegalArgumentException("invalid type " + type);
    }

    public Representation getAutoIndexedProperties(String type) {
        AutoIndexer<? extends PropertyContainer> indexer = this.getAutoIndexerForType(type);
        return ListRepresentation.string((Iterable)indexer.getAutoIndexedProperties());
    }

    public void startAutoIndexingProperty(String type, String property) {
        AutoIndexer<? extends PropertyContainer> indexer = this.getAutoIndexerForType(type);
        indexer.startAutoIndexingProperty(property);
    }

    public void stopAutoIndexingProperty(String type, String property) {
        AutoIndexer<? extends PropertyContainer> indexer = this.getAutoIndexerForType(type);
        indexer.stopAutoIndexingProperty(property);
    }

    public RelationshipRepresentation createRelationship(long startNodeId, long endNodeId, String type, Map<String, Object> properties) throws StartNodeNotFoundException, EndNodeNotFoundException, PropertyValueException {
        Node end;
        Node start;
        try {
            start = this.node(startNodeId);
        }
        catch (NodeNotFoundException e) {
            throw new StartNodeNotFoundException(e);
        }
        try {
            end = this.node(endNodeId);
        }
        catch (NodeNotFoundException e) {
            throw new EndNodeNotFoundException(e);
        }
        Relationship rel = start.createRelationshipTo(end, RelationshipType.withName((String)type));
        this.propertySetter.setProperties((PropertyContainer)rel, properties);
        return new RelationshipRepresentation(rel);
    }

    public RelationshipRepresentation getRelationship(long relationshipId) throws RelationshipNotFoundException {
        return new RelationshipRepresentation(this.relationship(relationshipId));
    }

    public void deleteRelationship(long relationshipId) throws RelationshipNotFoundException {
        this.relationship(relationshipId).delete();
    }

    public ListRepresentation getNodeRelationships(long nodeId, RelationshipDirection direction, Collection<String> types) throws NodeNotFoundException {
        PathExpander expander;
        Node node = this.node(nodeId);
        if (types.isEmpty()) {
            expander = PathExpanders.forDirection((Direction)direction.internal);
        } else {
            PathExpanderBuilder builder = PathExpanderBuilder.empty();
            for (String type : types) {
                builder = builder.add(RelationshipType.withName((String)type), direction.internal);
            }
            expander = builder.build();
        }
        return RelationshipRepresentation.list(expander.expand(Paths.singleNodePath((Node)node), BranchState.NO_STATE));
    }

    public Representation getNodeDegree(long nodeId, RelationshipDirection direction, Collection<String> types) throws NodeNotFoundException {
        Node node = this.node(nodeId);
        if (types.isEmpty()) {
            return PropertiesRepresentation.value(node.getDegree(direction.internal));
        }
        int sum = 0;
        for (String type : types) {
            sum += node.getDegree(RelationshipType.withName((String)type), direction.internal);
        }
        return PropertiesRepresentation.value(sum);
    }

    public PropertiesRepresentation getAllRelationshipProperties(long relationshipId) throws RelationshipNotFoundException {
        return new PropertiesRepresentation((PropertyContainer)this.relationship(relationshipId));
    }

    public Representation getRelationshipProperty(long relationshipId, String key) throws NoSuchPropertyException, RelationshipNotFoundException {
        Relationship relationship = this.relationship(relationshipId);
        try {
            return PropertiesRepresentation.value(relationship.getProperty(key));
        }
        catch (NotFoundException e) {
            throw new NoSuchPropertyException((PropertyContainer)relationship, key);
        }
    }

    public void setAllRelationshipProperties(long relationshipId, Map<String, Object> properties) throws PropertyValueException, RelationshipNotFoundException {
        this.propertySetter.setAllProperties((PropertyContainer)this.relationship(relationshipId), properties);
    }

    public void setRelationshipProperty(long relationshipId, String key, Object value) throws PropertyValueException, RelationshipNotFoundException {
        Relationship relationship = this.relationship(relationshipId);
        this.propertySetter.setProperty((PropertyContainer)relationship, key, value);
    }

    public void removeAllRelationshipProperties(long relationshipId) throws RelationshipNotFoundException, PropertyValueException {
        this.propertySetter.setAllProperties((PropertyContainer)this.relationship(relationshipId), null);
    }

    public void removeRelationshipProperty(long relationshipId, String key) throws RelationshipNotFoundException, NoSuchPropertyException {
        Relationship relationship = this.relationship(relationshipId);
        if (relationship.removeProperty(key) == null) {
            throw new NoSuchPropertyException((PropertyContainer)relationship, key);
        }
    }

    public Representation nodeIndexRoot() {
        return new NodeIndexRootRepresentation(this.graphDb.index());
    }

    public Representation relationshipIndexRoot() {
        return new RelationshipIndexRootRepresentation(this.graphDb.index());
    }

    public IndexedEntityRepresentation addToRelationshipIndex(String indexName, String key, String value, long relationshipId) {
        Relationship relationship = this.graphDb.getRelationshipById(relationshipId);
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        index.add((PropertyContainer)relationship, key, (Object)value);
        return new IndexedEntityRepresentation(relationship, key, value, (IndexRepresentation)new RelationshipIndexRepresentation(indexName, Collections.emptyMap()));
    }

    public IndexedEntityRepresentation addToNodeIndex(String indexName, String key, String value, long nodeId) {
        Node node = this.graphDb.getNodeById(nodeId);
        Index index = this.graphDb.index().forNodes(indexName);
        index.add((PropertyContainer)node, key, (Object)value);
        return new IndexedEntityRepresentation(node, key, value, (IndexRepresentation)new NodeIndexRepresentation(indexName, Collections.emptyMap()));
    }

    public void removeFromNodeIndex(String indexName, String key, String value, long id) {
        this.graphDb.index().forNodes(indexName).remove((PropertyContainer)this.graphDb.getNodeById(id), key, (Object)value);
    }

    public void removeFromNodeIndexNoValue(String indexName, String key, long id) {
        this.graphDb.index().forNodes(indexName).remove((PropertyContainer)this.graphDb.getNodeById(id), key);
    }

    public void removeFromNodeIndexNoKeyValue(String indexName, long id) {
        this.graphDb.index().forNodes(indexName).remove((PropertyContainer)this.graphDb.getNodeById(id));
    }

    public void removeFromRelationshipIndex(String indexName, String key, String value, long id) {
        this.graphDb.index().forRelationships(indexName).remove((PropertyContainer)this.graphDb.getRelationshipById(id), key, (Object)value);
    }

    public void removeFromRelationshipIndexNoValue(String indexName, String key, long id) {
        this.graphDb.index().forRelationships(indexName).remove((PropertyContainer)this.graphDb.getRelationshipById(id), key);
    }

    public void removeFromRelationshipIndexNoKeyValue(String indexName, long id) {
        this.graphDb.index().forRelationships(indexName).remove((PropertyContainer)this.graphDb.getRelationshipById(id));
    }

    public IndexedEntityRepresentation getIndexedNode(String indexName, String key, String value, long id) {
        if (!this.nodeIsIndexed(indexName, key, value, id)) {
            throw new NotFoundException();
        }
        Node node = this.graphDb.getNodeById(id);
        return new IndexedEntityRepresentation(node, key, value, (IndexRepresentation)new NodeIndexRepresentation(indexName, Collections.emptyMap()));
    }

    public IndexedEntityRepresentation getIndexedRelationship(String indexName, String key, String value, long id) {
        if (!this.relationshipIsIndexed(indexName, key, value, id)) {
            throw new NotFoundException();
        }
        Relationship node = this.graphDb.getRelationshipById(id);
        return new IndexedEntityRepresentation(node, key, value, (IndexRepresentation)new RelationshipIndexRepresentation(indexName, Collections.emptyMap()));
    }

    public ListRepresentation getIndexedNodes(String indexName, final String key, final String value) {
        if (!this.graphDb.index().existsForNodes(indexName)) {
            throw new NotFoundException();
        }
        Index index = this.graphDb.index().forNodes(indexName);
        final NodeIndexRepresentation indexRepresentation = new NodeIndexRepresentation(indexName);
        IndexHits indexHits = index.get(key, (Object)value);
        IterableWrapper<Representation, Node> results = new IterableWrapper<Representation, Node>((Iterable)indexHits){

            protected Representation underlyingObjectToObject(Node node) {
                return new IndexedEntityRepresentation(node, key, value, indexRepresentation);
            }
        };
        return new ListRepresentation(RepresentationType.NODE, (Iterable)results);
    }

    public ListRepresentation getIndexedNodesByQuery(String indexName, String query, String sort) {
        return this.getIndexedNodesByQuery(indexName, null, query, sort);
    }

    public ListRepresentation getIndexedNodesByQuery(String indexName, String key, String query, String sort) {
        if (!this.graphDb.index().existsForNodes(indexName)) {
            throw new NotFoundException();
        }
        if (query == null) {
            return this.toListNodeRepresentation();
        }
        Index index = this.graphDb.index().forNodes(indexName);
        IndexResultOrder order = this.getOrdering(sort);
        QueryContext queryCtx = order.updateQueryContext(new QueryContext((Object)query));
        IndexHits result = index.query(key, (Object)queryCtx);
        return this.toListNodeRepresentation((IndexHits<Node>)result, order);
    }

    private ListRepresentation toListNodeRepresentation() {
        return new ListRepresentation(RepresentationType.NODE, Collections.emptyList());
    }

    private ListRepresentation toListNodeRepresentation(final IndexHits<Node> result, final IndexResultOrder order) {
        if (result == null) {
            return new ListRepresentation(RepresentationType.NODE, Collections.emptyList());
        }
        IterableWrapper<Representation, Node> results = new IterableWrapper<Representation, Node>(result){

            protected Representation underlyingObjectToObject(Node node) {
                NodeRepresentation nodeRepresentation = new NodeRepresentation(node);
                if (order == null) {
                    return nodeRepresentation;
                }
                return order.getRepresentationFor((Representation)nodeRepresentation, result.currentScore());
            }
        };
        return new ListRepresentation(RepresentationType.NODE, (Iterable)results);
    }

    private ListRepresentation toListRelationshipRepresentation() {
        return new ListRepresentation(RepresentationType.RELATIONSHIP, Collections.emptyList());
    }

    private ListRepresentation toListRelationshipRepresentation(final IndexHits<Relationship> result, final IndexResultOrder order) {
        if (result == null) {
            return new ListRepresentation(RepresentationType.RELATIONSHIP, Collections.emptyList());
        }
        IterableWrapper<Representation, Relationship> results = new IterableWrapper<Representation, Relationship>(result){

            protected Representation underlyingObjectToObject(Relationship rel) {
                RelationshipRepresentation relationshipRepresentation = new RelationshipRepresentation(rel);
                if (order != null) {
                    return order.getRepresentationFor((Representation)relationshipRepresentation, result.currentScore());
                }
                return relationshipRepresentation;
            }
        };
        return new ListRepresentation(RepresentationType.RELATIONSHIP, (Iterable)results);
    }

    public Pair<IndexedEntityRepresentation, Boolean> getOrCreateIndexedNode(String indexName, String key, String value, Long nodeOrNull, Map<String, Object> properties) throws BadInputException, NodeNotFoundException {
        boolean created;
        Node result;
        this.assertIsLegalIndexName(indexName);
        if (nodeOrNull != null) {
            if (properties != null) {
                throw new InvalidArgumentsException("Cannot specify properties for a new node, when a node to index is specified.");
            }
            Node node = this.node(nodeOrNull);
            result = (Node)this.graphDb.index().forNodes(indexName).putIfAbsent((PropertyContainer)node, key, (Object)value);
            boolean bl = created = result == null;
            if (created) {
                UniqueNodeFactory factory = new UniqueNodeFactory(indexName, properties);
                UniqueFactory.UniqueEntity entity = factory.getOrCreateWithOutcome(key, value);
                created = ((Node)entity.entity()).getId() == node.getId() || entity.wasCreated();
                result = (Node)entity.entity();
            }
        } else {
            if (properties != null) {
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    entry.setValue(this.propertySetter.convert(entry.getValue()));
                }
            }
            UniqueNodeFactory factory = new UniqueNodeFactory(indexName, properties);
            UniqueFactory.UniqueEntity entity = factory.getOrCreateWithOutcome(key, value);
            result = (Node)entity.entity();
            created = entity.wasCreated();
        }
        return Pair.of((Object)new IndexedEntityRepresentation(result, key, value, (IndexRepresentation)new NodeIndexRepresentation(indexName, Collections.emptyMap())), (Object)created);
    }

    public Pair<IndexedEntityRepresentation, Boolean> getOrCreateIndexedRelationship(String indexName, String key, String value, Long relationshipOrNull, Long startNode, String type, Long endNode, Map<String, Object> properties) throws BadInputException, RelationshipNotFoundException, NodeNotFoundException {
        boolean created;
        Relationship result;
        this.assertIsLegalIndexName(indexName);
        if (relationshipOrNull != null) {
            if (startNode != null || type != null || endNode != null || properties != null) {
                throw new InvalidArgumentsException("Either specify a relationship to index uniquely, or the means for creating it.");
            }
            Relationship relationship = this.relationship(relationshipOrNull);
            result = (Relationship)this.graphDb.index().forRelationships(indexName).putIfAbsent((PropertyContainer)relationship, key, (Object)value);
            created = result == null;
            if (created) {
                UniqueRelationshipFactory factory = new UniqueRelationshipFactory(indexName, relationship.getStartNode(), relationship.getEndNode(), relationship.getType().name(), properties);
                UniqueFactory.UniqueEntity entity = factory.getOrCreateWithOutcome(key, value);
                created = ((Relationship)entity.entity()).getId() == relationship.getId() || entity.wasCreated();
                result = (Relationship)entity.entity();
            }
        } else {
            if (startNode == null || type == null || endNode == null) {
                throw new InvalidArgumentsException("Either specify a relationship to index uniquely, or the means for creating it.");
            }
            UniqueRelationshipFactory factory = new UniqueRelationshipFactory(indexName, this.node(startNode), this.node(endNode), type, properties);
            UniqueFactory.UniqueEntity entity = factory.getOrCreateWithOutcome(key, value);
            result = (Relationship)entity.entity();
            created = entity.wasCreated();
        }
        return Pair.of((Object)new IndexedEntityRepresentation(result, key, value, (IndexRepresentation)new RelationshipIndexRepresentation(indexName, Collections.emptyMap())), (Object)created);
    }

    public Representation getAutoIndexedNodes(String key, String value) {
        ReadableIndex index = this.graphDb.index().getNodeAutoIndexer().getAutoIndex();
        return this.toListNodeRepresentation((IndexHits<Node>)index.get(key, (Object)value), null);
    }

    public ListRepresentation getAutoIndexedNodesByQuery(String query) {
        if (query != null) {
            ReadableIndex index = this.graphDb.index().getNodeAutoIndexer().getAutoIndex();
            return this.toListNodeRepresentation((IndexHits<Node>)index.query((Object)query), null);
        }
        return this.toListNodeRepresentation();
    }

    public ListRepresentation getIndexedRelationships(String indexName, final String key, final String value) {
        if (!this.graphDb.index().existsForRelationships(indexName)) {
            throw new NotFoundException();
        }
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        final RelationshipIndexRepresentation indexRepresentation = new RelationshipIndexRepresentation(indexName);
        IterableWrapper<Representation, Relationship> result = new IterableWrapper<Representation, Relationship>((Iterable)index.get(key, (Object)value)){

            protected Representation underlyingObjectToObject(Relationship relationship) {
                return new IndexedEntityRepresentation(relationship, key, value, indexRepresentation);
            }
        };
        return new ListRepresentation(RepresentationType.RELATIONSHIP, (Iterable)result);
    }

    public ListRepresentation getIndexedRelationshipsByQuery(String indexName, String query, String sort) {
        return this.getIndexedRelationshipsByQuery(indexName, null, query, sort);
    }

    public ListRepresentation getIndexedRelationshipsByQuery(String indexName, String key, String query, String sort) {
        if (!this.graphDb.index().existsForRelationships(indexName)) {
            throw new NotFoundException();
        }
        if (query == null) {
            return this.toListRelationshipRepresentation();
        }
        RelationshipIndex index = this.graphDb.index().forRelationships(indexName);
        IndexResultOrder order = this.getOrdering(sort);
        QueryContext queryCtx = order.updateQueryContext(new QueryContext((Object)query));
        return this.toListRelationshipRepresentation((IndexHits<Relationship>)index.query(key, (Object)queryCtx), order);
    }

    public Representation getAutoIndexedRelationships(String key, String value) {
        ReadableRelationshipIndex index = this.graphDb.index().getRelationshipAutoIndexer().getAutoIndex();
        return this.toListRelationshipRepresentation((IndexHits<Relationship>)index.get(key, (Object)value), null);
    }

    public ListRepresentation getAutoIndexedRelationshipsByQuery(String query) {
        ReadableRelationshipIndex index = this.graphDb.index().getRelationshipAutoIndexer().getAutoIndex();
        IndexHits results = query != null ? index.query((Object)query) : null;
        return this.toListRelationshipRepresentation((IndexHits<Relationship>)results, null);
    }

    public ListRepresentation traverse(long startNode, Map<String, Object> description, TraverserReturnType returnType) {
        Node node = this.graphDb.getNodeById(startNode);
        TraversalDescription traversalDescription = this.traversalDescriptionBuilder.from(description);
        Traverser paths = traversalDescription.traverse(node);
        return this.toListPathRepresentation((Iterable<Path>)paths, returnType);
    }

    private ListRepresentation toListPathRepresentation(final Iterable<Path> paths, final TraverserReturnType returnType) {
        IterableWrapper<Representation, Path> result = new IterableWrapper<Representation, Path>(paths){

            protected Representation underlyingObjectToObject(Path position) {
                return returnType.toRepresentation(position);
            }

            public Iterator<Representation> iterator() {
                return ResourceClosingIterator.newResourceIterator((Iterator)super.iterator(), (Resource[])new Resource[]{() -> paths.forEach(Path::close)});
            }
        };
        return new ListRepresentation(returnType.repType, (Iterable)result);
    }

    public ListRepresentation pagedTraverse(String traverserId, TraverserReturnType returnType) {
        Lease lease = this.leases.getLeaseById(traverserId);
        if (lease == null) {
            throw new NotFoundException(String.format("The traverser with id [%s] was not found", traverserId));
        }
        PagedTraverser traverser = lease.getLeasedItemAndRenewLease();
        Object paths = traverser.next();
        if (paths != null) {
            return this.toListPathRepresentation((Iterable<Path>)paths, returnType);
        }
        this.leases.remove(traverserId);
        throw new NotFoundException(String.format("The results for paged traverser with id [%s] have been fully enumerated", traverserId));
    }

    public String createPagedTraverser(long nodeId, Map<String, Object> description, int pageSize, int leaseTime) {
        Node node = this.graphDb.getNodeById(nodeId);
        TraversalDescription traversalDescription = this.traversalDescriptionBuilder.from(description);
        PagedTraverser traverser = new PagedTraverser(traversalDescription.traverse(node), pageSize);
        return this.leases.createLease(leaseTime, traverser).getId();
    }

    public boolean removePagedTraverse(String traverserId) {
        Lease lease = this.leases.getLeaseById(traverserId);
        if (lease == null) {
            return false;
        }
        this.leases.remove(lease.getId());
        return true;
    }

    public PathRepresentation findSinglePath(long startId, long endId, Map<String, Object> map) {
        Node endNode;
        Node startNode;
        FindParams findParams = new FindParams(startId, endId, map).invoke();
        PathFinder<? extends Path> finder = findParams.getFinder();
        Path path = finder.findSinglePath(startNode = findParams.getStartNode(), endNode = findParams.getEndNode());
        if (path == null) {
            throw new NotFoundException();
        }
        return findParams.pathRepresentationOf(path);
    }

    public ListRepresentation findPaths(long startId, long endId, Map<String, Object> map) {
        final FindParams findParams = new FindParams(startId, endId, map).invoke();
        PathFinder<? extends Path> finder = findParams.getFinder();
        Node startNode = findParams.getStartNode();
        Node endNode = findParams.getEndNode();
        Iterable paths = finder.findAllPaths(startNode, endNode);
        IterableWrapper<PathRepresentation, Path> pathRepresentations = new IterableWrapper<PathRepresentation, Path>(paths){

            protected PathRepresentation underlyingObjectToObject(Path path) {
                return findParams.pathRepresentationOf(path);
            }
        };
        return new ListRepresentation(RepresentationType.PATH, (Iterable)pathRepresentations);
    }

    private IndexResultOrder getOrdering(String order) {
        if (INDEX_ORDER.equalsIgnoreCase(order)) {
            return IndexResultOrder.INDEX_ORDER;
        }
        if (RELEVANCE_ORDER.equalsIgnoreCase(order)) {
            return IndexResultOrder.RELEVANCE_ORDER;
        }
        if (SCORE_ORDER.equalsIgnoreCase(order)) {
            return IndexResultOrder.SCORE_ORDER;
        }
        return IndexResultOrder.NONE;
    }

    private void assertIsLegalIndexName(String indexName) {
        if (indexName == null || indexName.equals("")) {
            throw new IllegalArgumentException("Index name must not be empty.");
        }
    }

    public ListRepresentation getNodesWithLabel(String labelName, Map<String, Object> properties) {
        ResourceIterator nodes;
        if (properties.size() == 0) {
            nodes = this.graphDb.findNodes(Label.label((String)labelName));
        } else if (properties.size() == 1) {
            Map.Entry prop = (Map.Entry)Iterables.single(properties.entrySet());
            nodes = this.graphDb.findNodes(Label.label((String)labelName), (String)prop.getKey(), prop.getValue());
        } else {
            throw new IllegalArgumentException("Too many properties specified. Either specify one property to filter by, or none at all.");
        }
        IterableWrapper<NodeRepresentation, Node> nodeRepresentations = new IterableWrapper<NodeRepresentation, Node>((Iterable)Iterators.asList((Iterator)nodes)){

            protected NodeRepresentation underlyingObjectToObject(Node node) {
                return new NodeRepresentation(node);
            }
        };
        return new ListRepresentation(RepresentationType.NODE, (Iterable)nodeRepresentations);
    }

    public ListRepresentation getAllLabels(boolean inUse) {
        ResourceIterable labels = inUse ? this.graphDb.getAllLabelsInUse() : this.graphDb.getAllLabels();
        Set labelNames = Iterables.asSet((Iterable)Iterables.map(label -> ValueRepresentation.string((String)label.name()), (Iterable)labels));
        return new ListRepresentation(RepresentationType.STRING, (Iterable)labelNames);
    }

    public IndexDefinitionRepresentation createSchemaIndex(String labelName, Iterable<String> propertyKey) {
        IndexCreator indexCreator = this.graphDb.schema().indexFor(Label.label((String)labelName));
        for (String key : propertyKey) {
            indexCreator = indexCreator.on(key);
        }
        return new IndexDefinitionRepresentation(indexCreator.create());
    }

    public ListRepresentation getSchemaIndexes() {
        Iterable definitions = this.graphDb.schema().getIndexes();
        Iterable representations = Iterables.map(definition -> new IndexDefinitionRepresentation((IndexDefinition)definition, this.graphDb.schema().getIndexState(definition), this.graphDb.schema().getIndexPopulationProgress(definition)), (Iterable)definitions);
        return new ListRepresentation(RepresentationType.INDEX_DEFINITION, representations);
    }

    public ListRepresentation getSchemaIndexes(String labelName) {
        Iterable definitions = this.graphDb.schema().getIndexes(Label.label((String)labelName));
        Iterable representations = Iterables.map(definition -> new IndexDefinitionRepresentation((IndexDefinition)definition, this.graphDb.schema().getIndexState(definition), this.graphDb.schema().getIndexPopulationProgress(definition)), (Iterable)definitions);
        return new ListRepresentation(RepresentationType.INDEX_DEFINITION, representations);
    }

    public boolean dropSchemaIndex(String labelName, String propertyKey) {
        boolean found = false;
        for (IndexDefinition index : this.graphDb.schema().getIndexes(Label.label((String)labelName))) {
            if (!propertyKey.equals(Iterables.single((Iterable)index.getPropertyKeys()))) continue;
            index.drop();
            found = true;
            break;
        }
        return found;
    }

    public ConstraintDefinitionRepresentation createPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        ConstraintCreator constraintCreator = this.graphDb.schema().constraintFor(Label.label((String)labelName));
        for (String key : propertyKeys) {
            constraintCreator = constraintCreator.assertPropertyIsUnique(key);
        }
        ConstraintDefinition constraintDefinition = constraintCreator.create();
        return new ConstraintDefinitionRepresentation(constraintDefinition);
    }

    public boolean dropPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        Set propertyKeysSet = Iterables.asSet(propertyKeys);
        ConstraintDefinition constraint = (ConstraintDefinition)Iterables.singleOrNull(this.filteredNodeConstraints(labelName, this.propertyUniquenessFilter(propertyKeysSet)));
        if (constraint != null) {
            constraint.drop();
        }
        return constraint != null;
    }

    public boolean dropNodePropertyExistenceConstraint(String labelName, Iterable<String> propertyKeys) {
        Set propertyKeysSet = Iterables.asSet(propertyKeys);
        ConstraintDefinition constraint = (ConstraintDefinition)Iterables.singleOrNull(this.filteredNodeConstraints(labelName, this.nodePropertyExistenceFilter(propertyKeysSet)));
        if (constraint != null) {
            constraint.drop();
        }
        return constraint != null;
    }

    public boolean dropRelationshipPropertyExistenceConstraint(String typeName, Iterable<String> propertyKeys) {
        Set propertyKeysSet = Iterables.asSet(propertyKeys);
        ConstraintDefinition constraint = (ConstraintDefinition)Iterables.singleOrNull(this.filteredRelationshipConstraints(typeName, this.relationshipPropertyExistenceFilter(propertyKeysSet)));
        if (constraint != null) {
            constraint.drop();
        }
        return constraint != null;
    }

    public ListRepresentation getNodePropertyExistenceConstraint(String labelName, Iterable<String> propertyKeys) {
        Set propertyKeysSet = Iterables.asSet(propertyKeys);
        Iterable<ConstraintDefinition> constraints = this.filteredNodeConstraints(labelName, this.nodePropertyExistenceFilter(propertyKeysSet));
        if (constraints.iterator().hasNext()) {
            Iterable representationIterable = Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, constraints);
            return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, representationIterable);
        }
        throw new IllegalArgumentException(String.format("Constraint with label %s for properties %s does not exist", labelName, propertyKeys));
    }

    public ListRepresentation getRelationshipPropertyExistenceConstraint(String typeName, Iterable<String> propertyKeys) {
        Set propertyKeysSet = Iterables.asSet(propertyKeys);
        Iterable<ConstraintDefinition> constraints = this.filteredRelationshipConstraints(typeName, this.relationshipPropertyExistenceFilter(propertyKeysSet));
        if (constraints.iterator().hasNext()) {
            Iterable representationIterable = Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, constraints);
            return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, representationIterable);
        }
        throw new IllegalArgumentException(String.format("Constraint with relationship type %s for properties %s does not exist", typeName, propertyKeys));
    }

    public ListRepresentation getPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        Set propertyKeysSet = Iterables.asSet(propertyKeys);
        Iterable<ConstraintDefinition> constraints = this.filteredNodeConstraints(labelName, this.propertyUniquenessFilter(propertyKeysSet));
        if (constraints.iterator().hasNext()) {
            Iterable representationIterable = Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, constraints);
            return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, representationIterable);
        }
        throw new IllegalArgumentException(String.format("Constraint with label %s for properties %s does not exist", labelName, propertyKeys));
    }

    private Iterable<ConstraintDefinition> filteredNodeConstraints(String labelName, Predicate<ConstraintDefinition> filter) {
        Iterable constraints = this.graphDb.schema().getConstraints(Label.label((String)labelName));
        return Iterables.filter(filter, (Iterable)constraints);
    }

    private Iterable<ConstraintDefinition> filteredRelationshipConstraints(String typeName, Predicate<ConstraintDefinition> filter) {
        RelationshipType type = RelationshipType.withName((String)typeName);
        Iterable constraints = this.graphDb.schema().getConstraints(type);
        return Iterables.filter(filter, (Iterable)constraints);
    }

    private Iterable<ConstraintDefinition> filteredNodeConstraints(String labelName, ConstraintType type) {
        return Iterables.filter(item -> item.isConstraintType(type), (Iterable)this.graphDb.schema().getConstraints(Label.label((String)labelName)));
    }

    private Iterable<ConstraintDefinition> filteredRelationshipConstraints(String typeName, ConstraintType type) {
        return Iterables.filter(item -> item.isConstraintType(type), (Iterable)this.graphDb.schema().getConstraints(RelationshipType.withName((String)typeName)));
    }

    private Predicate<ConstraintDefinition> propertyUniquenessFilter(Set<String> propertyKeysSet) {
        return item -> item.isConstraintType(ConstraintType.UNIQUENESS) && propertyKeysSet.equals(Iterables.asSet((Iterable)item.getPropertyKeys()));
    }

    private Predicate<ConstraintDefinition> nodePropertyExistenceFilter(Set<String> propertyKeysSet) {
        return item -> item.isConstraintType(ConstraintType.NODE_PROPERTY_EXISTENCE) && propertyKeysSet.equals(Iterables.asSet((Iterable)item.getPropertyKeys()));
    }

    private Predicate<ConstraintDefinition> relationshipPropertyExistenceFilter(Set<String> propertyKeysSet) {
        return item -> item.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE) && propertyKeysSet.equals(Iterables.asSet((Iterable)item.getPropertyKeys()));
    }

    public ListRepresentation getConstraints() {
        return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, (Iterable)this.graphDb.schema().getConstraints()));
    }

    public ListRepresentation getLabelConstraints(String labelName) {
        return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, this.filteredNodeConstraints(labelName, Predicates.alwaysTrue())));
    }

    public Representation getLabelUniquenessConstraints(String labelName) {
        return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, this.filteredNodeConstraints(labelName, ConstraintType.UNIQUENESS)));
    }

    public Representation getLabelExistenceConstraints(String labelName) {
        return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, this.filteredNodeConstraints(labelName, ConstraintType.NODE_PROPERTY_EXISTENCE)));
    }

    public Representation getRelationshipTypeExistenceConstraints(String typeName) {
        return new ListRepresentation(RepresentationType.CONSTRAINT_DEFINITION, Iterables.map(this.CONSTRAINT_DEF_TO_REPRESENTATION, this.filteredRelationshipConstraints(typeName, ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)));
    }

    static /* synthetic */ PathRepresentationCreator access$100() {
        return PATH_REPRESENTATION_CREATOR;
    }

    private static interface PathRepresentationCreator<T extends Path> {
        public PathRepresentation<T> from(T var1);
    }

    private static enum IndexResultOrder {
        INDEX_ORDER{

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original.sort(Sort.INDEXORDER);
            }
        }
        ,
        RELEVANCE_ORDER{

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original.sort(Sort.RELEVANCE);
            }
        }
        ,
        SCORE_ORDER{

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original.sortByScore();
            }
        }
        ,
        NONE{

            @Override
            Representation getRepresentationFor(Representation delegate, float score) {
                return delegate;
            }

            @Override
            QueryContext updateQueryContext(QueryContext original) {
                return original;
            }
        };


        Representation getRepresentationFor(Representation delegate, float score) {
            if (delegate instanceof NodeRepresentation) {
                return new ScoredNodeRepresentation((NodeRepresentation)delegate, score);
            }
            if (delegate instanceof RelationshipRepresentation) {
                return new ScoredRelationshipRepresentation((RelationshipRepresentation)delegate, score);
            }
            return delegate;
        }

        abstract QueryContext updateQueryContext(QueryContext var1);
    }

    private class FindParams {
        private final long startId;
        private final long endId;
        private final Map<String, Object> map;
        private Node startNode;
        private Node endNode;
        private PathFinder<? extends Path> finder;
        private PathRepresentationCreator representationCreator = DatabaseActions.access$100();

        FindParams(long startId, long endId, Map<String, Object> map) {
            this.startId = startId;
            this.endId = endId;
            this.map = map;
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public PathFinder<? extends Path> getFinder() {
            return this.finder;
        }

        public PathRepresentation<? extends Path> pathRepresentationOf(Path path) {
            return this.representationCreator.from(path);
        }

        public FindParams invoke() {
            this.startNode = DatabaseActions.this.graphDb.getNodeById(this.startId);
            this.endNode = DatabaseActions.this.graphDb.getNodeById(this.endId);
            Integer maxDepthObj = (Integer)this.map.get("max_depth");
            int maxDepth = maxDepthObj != null ? maxDepthObj : 1;
            PathExpander expander = RelationshipExpanderBuilder.describeRelationships(this.map);
            String algorithm = (String)this.map.get("algorithm");
            algorithm = algorithm != null ? algorithm : "shortestPath";
            this.finder = this.getAlgorithm(algorithm, expander, maxDepth);
            return this;
        }

        private PathFinder<? extends Path> getAlgorithm(String algorithm, PathExpander expander, int maxDepth) {
            if (algorithm.equals("shortestPath")) {
                return GraphAlgoFactory.shortestPath((PathExpander)expander, (int)maxDepth);
            }
            if (algorithm.equals("allSimplePaths")) {
                return GraphAlgoFactory.allSimplePaths((PathExpander)expander, (int)maxDepth);
            }
            if (algorithm.equals("allPaths")) {
                return GraphAlgoFactory.allPaths((PathExpander)expander, (int)maxDepth);
            }
            if (algorithm.equals("dijkstra")) {
                String costProperty = (String)this.map.get("cost_property");
                Number defaultCost = (Number)this.map.get("default_cost");
                CostEvaluator costEvaluator = defaultCost == null ? CommonEvaluators.doubleCostEvaluator((String)costProperty) : CommonEvaluators.doubleCostEvaluator((String)costProperty, (double)defaultCost.doubleValue());
                this.representationCreator = WEIGHTED_PATH_REPRESENTATION_CREATOR;
                return GraphAlgoFactory.dijkstra((PathExpander)expander, (CostEvaluator)costEvaluator);
            }
            throw new RuntimeException("Failed to find matching algorithm");
        }
    }

    private class UniqueNodeFactory
    extends UniqueFactory.UniqueNodeFactory {
        private final Map<String, Object> properties;

        UniqueNodeFactory(String index, Map<String, Object> properties) {
            super((GraphDatabaseService)DatabaseActions.this.graphDb, index);
            this.properties = properties;
        }

        protected void initialize(Node node, Map<String, Object> indexed) {
            for (Map.Entry<String, Object> property : (this.properties == null ? indexed : this.properties).entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
        }
    }

    private class UniqueRelationshipFactory
    extends UniqueFactory.UniqueRelationshipFactory {
        private final Node start;
        private final Node end;
        private final RelationshipType type;
        private final Map<String, Object> properties;

        UniqueRelationshipFactory(String index, Node start, Node end, String type, Map<String, Object> properties) {
            super((GraphDatabaseService)DatabaseActions.this.graphDb, index);
            this.start = start;
            this.end = end;
            this.type = RelationshipType.withName((String)type);
            this.properties = properties;
        }

        protected Relationship create(Map<String, Object> ignored) {
            return this.start.createRelationshipTo(this.end, this.type);
        }

        protected void initialize(Relationship relationship, Map<String, Object> indexed) {
            for (Map.Entry<String, Object> property : (this.properties == null ? indexed : this.properties).entrySet()) {
                relationship.setProperty(property.getKey(), property.getValue());
            }
        }
    }

    public static enum RelationshipDirection {
        all(Direction.BOTH),
        in(Direction.INCOMING),
        out(Direction.OUTGOING);

        final Direction internal;

        private RelationshipDirection(Direction internal) {
            this.internal = internal;
        }
    }

    public static class Provider
    extends InjectableProvider<DatabaseActions> {
        private final DatabaseActions database;

        public Provider(DatabaseActions database) {
            super(DatabaseActions.class);
            this.database = database;
        }

        public DatabaseActions getValue(HttpContext c) {
            return this.database;
        }
    }
}

