/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTRequestGenerator;
import org.neo4j.server.rest.UniqueStrings;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

public class SchemaIndexIT
extends AbstractRestFunctionalTestBase {
    private final Factory<String> labels = UniqueStrings.withPrefix("label");
    private final Factory<String> properties = UniqueStrings.withPrefix("property");

    @Documented(value="Create index.\n\nThis will start a background job in the database that will create and populate the index.\nYou can check the status of your index by listing all the indexes for the relevant label.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void create_index() throws JsonParseException {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Collections.singletonList(propertyKey)});
        String result = ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri(labelName)).entity();
        Map serialized = JsonHelper.jsonToMap((String)result);
        HashMap<String, Object> index = new HashMap<String, Object>();
        index.put("label", labelName);
        index.put("property_keys", Collections.singletonList(propertyKey));
        Assert.assertThat((Object)serialized, (Matcher)Matchers.equalTo(index));
    }

    @Documented(value="List indexes for a label.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_indexes_for_label() throws Exception {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        this.createIndex(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Collections.singletonList(propertyKey)});
        List<Map<String, Object>> serializedList = this.retryOnStillPopulating(() -> ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).get(this.getSchemaIndexLabelUri(labelName)).entity());
        HashMap<String, Object> index = new HashMap<String, Object>();
        index.put("label", labelName);
        index.put("property_keys", Collections.singletonList(propertyKey));
        Assert.assertThat(serializedList, (Matcher)Matchers.hasItem(index));
    }

    private List<Map<String, Object>> retryOnStillPopulating(Callable<String> callable) throws Exception {
        List serializedList;
        long endTime = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
        do {
            String result = callable.call();
            serializedList = JsonHelper.jsonToList((String)result);
            if (System.currentTimeMillis() <= endTime) continue;
            Assert.fail((String)("Indexes didn't populate correctly, last result '" + result + "'"));
        } while (this.stillPopulating(serializedList));
        return serializedList;
    }

    private boolean stillPopulating(List<Map<String, Object>> serializedList) {
        for (Map<String, Object> map : serializedList) {
            if (!map.containsKey("population_progress")) continue;
            return true;
        }
        return false;
    }

    @Documented(value="Get all indexes.")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_indexes() throws Exception {
        this.data.get();
        String labelName1 = (String)this.labels.newInstance();
        String propertyKey1 = (String)this.properties.newInstance();
        String labelName2 = (String)this.labels.newInstance();
        String propertyKey2 = (String)this.properties.newInstance();
        this.createIndex(labelName1, propertyKey1);
        this.createIndex(labelName2, propertyKey2);
        List<Map<String, Object>> serializedList = this.retryOnStillPopulating(() -> ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).get(this.getSchemaIndexUri()).entity());
        HashMap<String, Object> index1 = new HashMap<String, Object>();
        index1.put("label", labelName1);
        index1.put("property_keys", Collections.singletonList(propertyKey1));
        HashMap<String, Object> index2 = new HashMap<String, Object>();
        index2.put("label", labelName2);
        index2.put("property_keys", Collections.singletonList(propertyKey2));
        Assert.assertThat(serializedList, (Matcher)Matchers.hasItems((Object[])new Map[]{index1, index2}));
    }

    @Documented(value="Drop index")
    @Test
    @GraphDescription.Graph(nodes={})
    public void drop_index() throws Exception {
        this.data.get();
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        IndexDefinition schemaIndex = this.createIndex(labelName, propertyKey);
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.graphdb(), (Label)Label.label((String)labelName)), (Matcher)Neo4jMatchers.containsOnly((Object[])new IndexDefinition[]{schemaIndex}));
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(204).delete(this.getSchemaIndexLabelPropertyUri(labelName, propertyKey)).entity();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.graphdb(), (Label)Label.label((String)labelName)), (Matcher)IsNot.not((Matcher)Neo4jMatchers.containsOnly((Object[])new IndexDefinition[]{schemaIndex})));
    }

    @Test
    public void create_existing_index() {
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        this.createIndex(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Collections.singletonList(propertyKey)});
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(409).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri(labelName));
    }

    @Test
    public void drop_non_existent_index() throws Exception {
        String labelName = (String)this.labels.newInstance();
        String propertyKey = (String)this.properties.newInstance();
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(404).delete(this.getSchemaIndexLabelPropertyUri(labelName, propertyKey));
    }

    @Test
    public void create_compound_index() {
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList((String)this.properties.newInstance(), (String)this.properties.newInstance())});
        ((RESTRequestGenerator)this.gen.get()).expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri((String)this.labels.newInstance()));
    }

    private IndexDefinition createIndex(String labelName, String propertyKey) {
        try (Transaction tx = this.graphdb().beginTx();){
            IndexDefinition indexDefinition = this.graphdb().schema().indexFor(Label.label((String)labelName)).on(propertyKey).create();
            tx.success();
            IndexDefinition indexDefinition2 = indexDefinition;
            return indexDefinition2;
        }
    }
}

