/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class AuthorizationWhitelistIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @Test
    public void shouldWhitelistBrowser() throws Exception {
        Assume.assumeTrue((boolean)this.browserIsLoaded());
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        this.server.start();
        HTTP.Response response = HTTP.GET(this.server.baseUri().resolve("browser/index.html").toString());
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    public void shouldNotWhitelistConsoleService() throws Exception {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        this.server.start();
        HTTP.Response response = HTTP.GET(this.server.baseUri().resolve("db/manage/server/console").toString());
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)401));
    }

    @Test
    public void shouldNotWhitelistDB() throws Exception {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), "true").build();
        this.server.start();
        HTTP.Response response = HTTP.GET(HTTP.GET(this.server.baseUri().resolve("db/data").toString()).location());
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.equalTo((Object)401));
    }

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private boolean browserIsLoaded() throws IOException {
        return this.getClass().getClassLoader().getResource("browser") != null;
    }
}

