/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

@RunWith(value=Theories.class)
public class ExplicitIndexIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;
    @DataPoints
    public static String[] candidates = new String[]{"", "get_or_create", "create_or_fail"};

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Before
    public void startServer() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withHttpsEnabled().withProperty("dbms.shell.enabled", "false").withProperty("dbms.security.auth_enabled", "false").withProperty(ServerSettings.maximum_response_header_size.name(), "5000").usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
    }

    @Theory
    public void shouldRejectIndexValueLargerThanConfiguredSize(String uniqueness) throws Exception {
        this.server.start();
        String nodeURI = HTTP.POST(this.server.baseUri().toString() + "db/data/node").header("Location");
        Random r = new Random();
        String value = "";
        for (int i = 0; i < 6000; ++i) {
            value = value + (char)(r.nextInt(26) + 97);
        }
        HTTP.Response response = HTTP.POST(this.server.baseUri().toString() + "db/data/index/node/favorites?uniqueness=" + uniqueness, HTTP.RawPayload.quotedJson("{ 'value': '" + value + " ', 'uri':'" + nodeURI + "', 'key': 'some-key' }"));
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.is((Object)413));
    }

    @Theory
    public void shouldNotRejectIndexValueThatIsJustSmallerThanConfiguredSize(String uniqueness) throws Exception {
        this.server.start();
        String nodeURI = HTTP.POST(this.server.baseUri().toString() + "db/data/node").header("Location");
        Random r = new Random();
        String value = "";
        for (int i = 0; i < 4000; ++i) {
            value = value + (char)(r.nextInt(26) + 97);
        }
        HTTP.Response response = HTTP.POST(this.server.baseUri().toString() + "db/data/index/node/favorites?uniqueness=" + uniqueness, HTTP.RawPayload.quotedJson("{ 'value': '" + value + " ', 'uri':'" + nodeURI + "', 'key': 'some-key' }"));
        Assert.assertThat((Object)response.status(), (Matcher)Matchers.is((Object)201));
    }
}

