/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import org.junit.After;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.string.UTF8;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class CommunityServerTestBase
extends ExclusiveServerTestBase {
    protected CommunityNeoServer server;

    @After
    public void cleanup() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    protected void startServer(boolean authEnabled) throws IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseSettings.auth_enabled.name(), Boolean.toString(authEnabled)).build();
        this.server.start();
    }

    protected String challengeResponse(String username, String password) {
        return "Basic " + this.base64(username + ":" + password);
    }

    protected String dataURL() {
        return this.server.baseUri().resolve("db/data/").toString();
    }

    protected String userURL(String username) {
        return this.server.baseUri().resolve("user/" + username).toString();
    }

    protected String passwordURL(String username) {
        return this.server.baseUri().resolve("user/" + username + "/password").toString();
    }

    protected String base64(String value) {
        return UTF8.decode((byte[])Base64.encode((String)value));
    }
}

