/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.net.URI;
import java.time.Clock;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.InvalidConcurrentTransactionAccess;
import org.neo4j.server.rest.web.TransactionUriScheme;
import org.neo4j.test.DoubleLatch;

public class ConcurrentTransactionAccessTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowSpecificExceptionOnConcurrentTransactionAccess() throws Exception {
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Mockito.mock(Clock.class), 0L, (LogProvider)NullLogProvider.getInstance());
        TransitionalPeriodTransactionMessContainer kernel = (TransitionalPeriodTransactionMessContainer)Mockito.mock(TransitionalPeriodTransactionMessContainer.class);
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        Mockito.when((Object)kernel.newTransaction((Transaction.Type)ArgumentMatchers.any(Transaction.Type.class), (LoginContext)ArgumentMatchers.any(LoginContext.class), ArgumentMatchers.anyLong())).thenReturn(Mockito.mock(TransitionalTxManagementKernelTransaction.class));
        TransactionFacade actions = new TransactionFacade(kernel, null, queryService, (TransactionRegistry)registry, (LogProvider)NullLogProvider.getInstance());
        TransactionHandle transactionHandle = actions.newTransactionHandle((TransactionUriScheme)new DisgustingUriScheme(), true, LoginContext.AUTH_DISABLED, -1L);
        DoubleLatch latch = new DoubleLatch();
        StatementDeserializer statements = (StatementDeserializer)Mockito.mock(StatementDeserializer.class);
        Mockito.when((Object)statements.hasNext()).thenAnswer(invocation -> {
            latch.startAndWaitForAllToStartAndFinish();
            return false;
        });
        new Thread(() -> transactionHandle.execute(statements, (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class), (HttpServletRequest)Mockito.mock(HttpServletRequest.class))).start();
        latch.waitForAllToStart();
        try {
            actions.findTransactionHandle(DisgustingUriScheme.parseTxId(transactionHandle.uri()));
            Assert.fail((String)"should have thrown exception");
        }
        catch (InvalidConcurrentTransactionAccess invalidConcurrentTransactionAccess) {
        }
        finally {
            latch.finish();
        }
    }

    private static class DisgustingUriScheme
    implements TransactionUriScheme {
        private DisgustingUriScheme() {
        }

        private static long parseTxId(URI txUri) {
            return DatatypeConverter.parseLong((String)txUri.toString());
        }

        public URI txUri(long id) {
            return URI.create(String.valueOf(id));
        }

        public URI txCommitUri(long id) {
            return this.txUri(id);
        }
    }
}

