/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.jackson.JsonGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.SpatialMocks;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.server.rest.transactional.Neo4jJsonCodec;
import org.neo4j.server.rest.transactional.TxStateCheckerTestSupport;

public class Neo4jJsonCodecTest
extends TxStateCheckerTestSupport {
    private Neo4jJsonCodec jsonCodec;
    private JsonGenerator jsonGenerator;

    @Before
    public void init() {
        this.jsonCodec = new Neo4jJsonCodec(TPTPMC);
        this.jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
    }

    @Test
    public void testPropertyContainerWriting() throws IOException {
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)propertyContainer.getAllProperties()).thenThrow(RuntimeException.class);
        boolean exceptionThrown = false;
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)propertyContainer);
        }
        catch (IllegalArgumentException e) {
            ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)0))).writeEndObject();
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testNodeWriting() throws IOException {
        PropertyContainer node = (PropertyContainer)Mockito.mock(Node.class);
        Mockito.when((Object)node.getAllProperties()).thenThrow(RuntimeException.class);
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)node);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void testRelationshipWriting() throws IOException {
        PropertyContainer relationship = (PropertyContainer)Mockito.mock(Relationship.class);
        Mockito.when((Object)relationship.getAllProperties()).thenThrow(RuntimeException.class);
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)relationship);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void testPathWriting() throws IOException {
        Path path = (Path)Mockito.mock(Path.class);
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)propertyContainer.getAllProperties()).thenThrow(RuntimeException.class);
        Mockito.when((Object)path.iterator()).thenReturn(Arrays.asList(propertyContainer).listIterator());
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testIteratorWriting() throws IOException {
        PropertyContainer propertyContainer = (PropertyContainer)Mockito.mock(PropertyContainer.class);
        Mockito.when((Object)propertyContainer.getAllProperties()).thenThrow(RuntimeException.class);
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, Arrays.asList(propertyContainer));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testByteArrayWriting() throws IOException {
        ((JsonGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.jsonGenerator)).writeNumber(ArgumentMatchers.anyInt());
        byte[] byteArray = new byte[]{1, 2, 3};
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, (Object)byteArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndArray();
    }

    @Test
    public void testMapWriting() throws IOException {
        ((JsonGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.jsonGenerator)).writeFieldName(ArgumentMatchers.anyString());
        try {
            this.jsonCodec.writeValue(this.jsonGenerator, new HashMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeEndObject();
    }

    @Test
    public void shouldWriteAMapContainingNullAsKeysAndValues() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(null, null);
        this.jsonCodec.writeValue(this.jsonGenerator, map);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)1))).writeFieldName("null");
    }

    @Test
    public void testGeographicPointWriting() throws IOException {
        SpatialMocks.MockPoint value = SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    public void testCartesianPointWriting() throws IOException {
        SpatialMocks.MockPoint value = SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    public void testGeometryWriting() throws IOException {
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        points.add(new Coordinate(new double[]{1.0, 2.0}));
        points.add(new Coordinate(new double[]{2.0, 3.0}));
        SpatialMocks.MockGeometry value = SpatialMocks.mockGeometry((String)"LineString", points, (CRS)SpatialMocks.mockCartesian());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }
}

