/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.domain.EndNodeNotFoundException;
import org.neo4j.server.rest.domain.EvaluationException;
import org.neo4j.server.rest.domain.PropertySettingStrategy;
import org.neo4j.server.rest.domain.StartNodeNotFoundException;
import org.neo4j.server.rest.domain.TraverserReturnType;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.IndexedEntityRepresentation;
import org.neo4j.server.rest.repr.InputFormat;
import org.neo4j.server.rest.repr.InvalidArgumentsException;
import org.neo4j.server.rest.repr.ListEntityRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.NoSuchPropertyException;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;

@Path(value="/")
public class RestfulGraphDatabase {
    private static final String PATH_NODE = "node/{nodeId}";
    private static final String PATH_NODE_PROPERTIES = "node/{nodeId}/properties";
    private static final String PATH_NODE_PROPERTY = "node/{nodeId}/properties/{key}";
    private static final String PATH_NODE_RELATIONSHIPS = "node/{nodeId}/relationships";
    private static final String PATH_RELATIONSHIP = "relationship/{relationshipId}";
    private static final String PATH_NODE_RELATIONSHIPS_W_DIR = "node/{nodeId}/relationships/{direction}";
    private static final String PATH_NODE_RELATIONSHIPS_W_DIR_N_TYPES = "node/{nodeId}/relationships/{direction}/{types}";
    private static final String PATH_RELATIONSHIP_PROPERTIES = "relationship/{relationshipId}/properties";
    private static final String PATH_RELATIONSHIP_PROPERTY = "relationship/{relationshipId}/properties/{key}";
    private static final String PATH_NODE_TRAVERSE = "node/{nodeId}/traverse/{returnType}";
    private static final String PATH_NODE_PATH = "node/{nodeId}/path";
    private static final String PATH_NODE_PATHS = "node/{nodeId}/paths";
    private static final String PATH_NODE_LABELS = "node/{nodeId}/labels";
    private static final String PATH_NODE_LABEL = "node/{nodeId}/labels/{label}";
    private static final String PATH_NODE_DEGREE = "node/{nodeId}/degree";
    private static final String PATH_NODE_DEGREE_W_DIR = "node/{nodeId}/degree/{direction}";
    private static final String PATH_NODE_DEGREE_W_DIR_N_TYPES = "node/{nodeId}/degree/{direction}/{types}";
    private static final String PATH_PROPERTY_KEYS = "propertykeys";
    protected static final String PATH_NAMED_NODE_INDEX = "index/node/{indexName}";
    protected static final String PATH_NODE_INDEX_GET = "index/node/{indexName}/{key}/{value}";
    protected static final String PATH_NODE_INDEX_QUERY_WITH_KEY = "index/node/{indexName}/{key}";
    protected static final String PATH_NODE_INDEX_ID = "index/node/{indexName}/{key}/{value}/{id}";
    protected static final String PATH_NODE_INDEX_REMOVE_KEY = "index/node/{indexName}/{key}/{id}";
    protected static final String PATH_NODE_INDEX_REMOVE = "index/node/{indexName}/{id}";
    protected static final String PATH_NAMED_RELATIONSHIP_INDEX = "index/relationship/{indexName}";
    protected static final String PATH_RELATIONSHIP_INDEX_GET = "index/relationship/{indexName}/{key}/{value}";
    protected static final String PATH_RELATIONSHIP_INDEX_QUERY_WITH_KEY = "index/relationship/{indexName}/{key}";
    protected static final String PATH_RELATIONSHIP_INDEX_ID = "index/relationship/{indexName}/{key}/{value}/{id}";
    protected static final String PATH_RELATIONSHIP_INDEX_REMOVE_KEY = "index/relationship/{indexName}/{key}/{id}";
    protected static final String PATH_RELATIONSHIP_INDEX_REMOVE = "index/relationship/{indexName}/{id}";
    public static final String PATH_AUTO_INDEX = "index/auto/{type}";
    protected static final String PATH_AUTO_INDEX_STATUS = "index/auto/{type}/status";
    protected static final String PATH_AUTO_INDEXED_PROPERTIES = "index/auto/{type}/properties";
    protected static final String PATH_AUTO_INDEX_PROPERTY_DELETE = "index/auto/{type}/properties/{property}";
    protected static final String PATH_AUTO_INDEX_GET = "index/auto/{type}/{key}/{value}";
    public static final String PATH_ALL_NODES_LABELED = "label/{label}/nodes";
    public static final String PATH_SCHEMA_INDEX_LABEL = "schema/index/{label}";
    public static final String PATH_SCHEMA_INDEX_LABEL_PROPERTY = "schema/index/{label}/{property}";
    public static final String PATH_SCHEMA_CONSTRAINT_LABEL = "schema/constraint/{label}";
    public static final String PATH_SCHEMA_CONSTRAINT_LABEL_UNIQUENESS = "schema/constraint/{label}/uniqueness";
    public static final String PATH_SCHEMA_CONSTRAINT_LABEL_EXISTENCE = "schema/constraint/{label}/existence";
    public static final String PATH_SCHEMA_CONSTRAINT_LABEL_UNIQUENESS_PROPERTY = "schema/constraint/{label}/uniqueness/{property}";
    public static final String PATH_SCHEMA_CONSTRAINT_LABEL_EXISTENCE_PROPERTY = "schema/constraint/{label}/existence/{property}";
    public static final String PATH_SCHEMA_RELATIONSHIP_CONSTRAINT_TYPE = "schema/relationship/constraint/{type}";
    public static final String PATH_SCHEMA_RELATIONSHIP_CONSTRAINT_TYPE_EXISTENCE = "schema/relationship/constraint/{type}/existence";
    public static final String PATH_SCHEMA_RELATIONSHIP_CONSTRAINT_EXISTENCE_PROPERTY = "schema/relationship/constraint/{type}/existence/{property}";
    public static final String NODE_AUTO_INDEX_TYPE = "node";
    public static final String RELATIONSHIP_AUTO_INDEX_TYPE = "relationship";
    private static final String SIXTY_SECONDS = "60";
    private static final String FIFTY_ENTRIES = "50";
    private static final String UNIQUENESS_MODE_GET_OR_CREATE = "get_or_create";
    private static final String UNIQUENESS_MODE_CREATE_OR_FAIL = "create_or_fail";
    private static final String HEADER_TRANSACTION = "Transaction";
    private final DatabaseActions actions;
    private Configuration config;
    private final OutputFormat output;
    private final InputFormat input;
    public static final String PATH_TO_CREATE_PAGED_TRAVERSERS = "node/{nodeId}/paged/traverse/{returnType}";
    public static final String PATH_TO_PAGED_TRAVERSERS = "node/{nodeId}/paged/traverse/{returnType}/{traverserId}";
    private final Function<Map.Entry<String, List<String>>, Pair<String, Object>> queryParamsToProperties = new Function<Map.Entry<String, List<String>>, Pair<String, Object>>(){

        @Override
        public Pair<String, Object> apply(Map.Entry<String, List<String>> queryEntry) {
            try {
                Object propertyValue = RestfulGraphDatabase.this.input.readValue(queryEntry.getValue().get(0));
                if (propertyValue instanceof Collection) {
                    propertyValue = PropertySettingStrategy.convertToNativeArray((Collection)propertyValue);
                }
                return Pair.of((Object)queryEntry.getKey(), (Object)propertyValue);
            }
            catch (BadInputException e) {
                throw new IllegalArgumentException(String.format("Unable to deserialize property value for %s.", queryEntry.getKey()), e);
            }
        }
    };

    public RestfulGraphDatabase(@Context InputFormat input, @Context OutputFormat output, @Context DatabaseActions actions, @Context Configuration config) {
        this.input = input;
        this.output = output;
        this.actions = actions;
        this.config = config;
    }

    public OutputFormat getOutputFormat() {
        return this.output;
    }

    private Response nothing() {
        return this.output.noContent();
    }

    private Long extractNodeIdOrNull(String uri) throws BadInputException {
        if (uri == null) {
            return null;
        }
        return this.extractNodeId(uri);
    }

    private long extractNodeId(String uri) throws BadInputException {
        try {
            return Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1));
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new BadInputException((Throwable)ex);
        }
    }

    private Long extractRelationshipIdOrNull(String uri) throws BadInputException {
        if (uri == null) {
            return null;
        }
        return this.extractRelationshipId(uri);
    }

    private long extractRelationshipId(String uri) throws BadInputException {
        return this.extractNodeId(uri);
    }

    @GET
    public Response getRoot() {
        return this.output.ok((Representation)this.actions.root());
    }

    @POST
    @Path(value="node")
    public Response createNode(String body) {
        try {
            return this.output.created(this.actions.createNode(this.input.readMap(body, new String[0]), new Label[0]));
        }
        catch (ArrayStoreException ase) {
            return this.generateBadRequestDueToMangledJsonResponse(body);
        }
        catch (ClassCastException | BadInputException e) {
            return this.output.badRequest(e);
        }
    }

    private Response generateBadRequestDueToMangledJsonResponse(String body) {
        return this.output.badRequest(MediaType.TEXT_PLAIN_TYPE, "Invalid JSON array in POST body: " + body);
    }

    @GET
    @Path(value="node/{nodeId}")
    public Response getNode(@PathParam(value="nodeId") long nodeId) {
        try {
            return this.output.ok((Representation)this.actions.getNode(nodeId));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @DELETE
    @Path(value="node/{nodeId}")
    public Response deleteNode(@PathParam(value="nodeId") long nodeId) {
        try {
            this.actions.deleteNode(nodeId);
            return this.nothing();
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    @PUT
    @Path(value="node/{nodeId}/properties")
    public Response setAllNodeProperties(@PathParam(value="nodeId") long nodeId, String body) {
        try {
            this.actions.setAllNodeProperties(nodeId, this.input.readMap(body, new String[0]));
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (ArrayStoreException ase) {
            return this.generateBadRequestDueToMangledJsonResponse(body);
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
        return this.nothing();
    }

    @GET
    @Path(value="node/{nodeId}/properties")
    public Response getAllNodeProperties(@PathParam(value="nodeId") long nodeId) {
        try {
            return this.output.response((Response.StatusType)Response.Status.OK, (Representation)this.actions.getAllNodeProperties(nodeId));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @PUT
    @Path(value="node/{nodeId}/properties/{key}")
    public Response setNodeProperty(@PathParam(value="nodeId") long nodeId, @PathParam(value="key") String key, String body) {
        try {
            this.actions.setNodeProperty(nodeId, key, this.input.readValue(body));
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (ArrayStoreException ase) {
            return this.generateBadRequestDueToMangledJsonResponse(body);
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
        return this.nothing();
    }

    @GET
    @Path(value="node/{nodeId}/properties/{key}")
    public Response getNodeProperty(@PathParam(value="nodeId") long nodeId, @PathParam(value="key") String key) {
        try {
            return this.output.ok(this.actions.getNodeProperty(nodeId, key));
        }
        catch (NoSuchPropertyException | NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @DELETE
    @Path(value="node/{nodeId}/properties/{key}")
    public Response deleteNodeProperty(@PathParam(value="nodeId") long nodeId, @PathParam(value="key") String key) {
        try {
            this.actions.removeNodeProperty(nodeId, key);
        }
        catch (NoSuchPropertyException | NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @DELETE
    @Path(value="node/{nodeId}/properties")
    public Response deleteAllNodeProperties(@PathParam(value="nodeId") long nodeId) {
        try {
            this.actions.removeAllNodeProperties(nodeId);
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (PropertyValueException e) {
            return this.output.badRequest((Throwable)((Object)e));
        }
        return this.nothing();
    }

    @POST
    @Path(value="node/{nodeId}/labels")
    public Response addNodeLabel(@PathParam(value="nodeId") long nodeId, String body) {
        block6: {
            try {
                Object rawInput = this.input.readValue(body);
                if (rawInput instanceof String) {
                    ArrayList<String> s = new ArrayList<String>();
                    s.add((String)rawInput);
                    this.actions.addLabelToNode(nodeId, s);
                    break block6;
                }
                if (rawInput instanceof Collection) {
                    this.actions.addLabelToNode(nodeId, (Collection)rawInput);
                    break block6;
                }
                throw new InvalidArgumentsException(String.format("Label name must be a string. Got: '%s'", rawInput));
            }
            catch (BadInputException e) {
                return this.output.badRequest(e);
            }
            catch (ArrayStoreException ase) {
                return this.generateBadRequestDueToMangledJsonResponse(body);
            }
            catch (NodeNotFoundException e) {
                return this.output.notFound(e);
            }
        }
        return this.nothing();
    }

    @PUT
    @Path(value="node/{nodeId}/labels")
    public Response setNodeLabels(@PathParam(value="nodeId") long nodeId, String body) {
        try {
            Object rawInput = this.input.readValue(body);
            if (!(rawInput instanceof Collection)) {
                throw new InvalidArgumentsException(String.format("Input must be an array of Strings. Got: '%s'", rawInput));
            }
            this.actions.setLabelsOnNode(nodeId, (Collection)rawInput);
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (ArrayStoreException ase) {
            return this.generateBadRequestDueToMangledJsonResponse(body);
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @DELETE
    @Path(value="node/{nodeId}/labels/{label}")
    public Response removeNodeLabel(@PathParam(value="nodeId") long nodeId, @PathParam(value="label") String labelName) {
        try {
            this.actions.removeLabelFromNode(nodeId, labelName);
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @GET
    @Path(value="node/{nodeId}/labels")
    public Response getNodeLabels(@PathParam(value="nodeId") long nodeId) {
        try {
            return this.output.ok((Representation)this.actions.getNodeLabels(nodeId));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="label/{label}/nodes")
    public Response getNodesWithLabelAndProperty(@PathParam(value="label") String labelName, @Context UriInfo uriInfo) {
        try {
            if (labelName.isEmpty()) {
                throw new InvalidArgumentsException("Empty label name");
            }
            Map properties = MapUtil.toMap((Iterable)Iterables.map(this.queryParamsToProperties, (Iterable)uriInfo.getQueryParameters().entrySet()));
            return this.output.ok((Representation)this.actions.getNodesWithLabel(labelName, properties));
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
    }

    @GET
    @Path(value="labels")
    public Response getAllLabels(@QueryParam(value="in_use") @DefaultValue(value="true") boolean inUse) {
        return this.output.ok((Representation)this.actions.getAllLabels(inUse));
    }

    @GET
    @Path(value="propertykeys")
    public Response getAllPropertyKeys() {
        return this.output.ok(this.actions.getAllPropertyKeys());
    }

    @POST
    @Path(value="node/{nodeId}/relationships")
    public Response createRelationship(@PathParam(value="nodeId") long startNodeId, String body) {
        Map properties;
        String type;
        long endNodeId;
        try {
            Map data = this.input.readMap(body, new String[0]);
            endNodeId = this.extractNodeId((String)data.get("to"));
            type = (String)data.get("type");
            properties = (Map)data.get("data");
        }
        catch (ClassCastException | BadInputException e) {
            return this.output.badRequest(e);
        }
        try {
            return this.output.created(this.actions.createRelationship(startNodeId, endNodeId, type, properties));
        }
        catch (StartNodeNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (EndNodeNotFoundException | BadInputException e) {
            return this.output.badRequest(e);
        }
    }

    @GET
    @Path(value="relationship/{relationshipId}")
    public Response getRelationship(@PathParam(value="relationshipId") long relationshipId) {
        try {
            return this.output.ok((Representation)this.actions.getRelationship(relationshipId));
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @DELETE
    @Path(value="relationship/{relationshipId}")
    public Response deleteRelationship(@PathParam(value="relationshipId") long relationshipId) {
        try {
            this.actions.deleteRelationship(relationshipId);
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @GET
    @Path(value="node/{nodeId}/relationships/{direction}")
    public Response getNodeRelationships(@PathParam(value="nodeId") long nodeId, @PathParam(value="direction") DatabaseActions.RelationshipDirection direction) {
        try {
            return this.output.ok((Representation)this.actions.getNodeRelationships(nodeId, direction, Collections.emptyList()));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="node/{nodeId}/relationships/{direction}/{types}")
    public Response getNodeRelationships(@PathParam(value="nodeId") long nodeId, @PathParam(value="direction") DatabaseActions.RelationshipDirection direction, @PathParam(value="types") AmpersandSeparatedCollection types) {
        try {
            return this.output.ok((Representation)this.actions.getNodeRelationships(nodeId, direction, types));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="node/{nodeId}/degree/{direction}")
    public Response getNodeDegree(@PathParam(value="nodeId") long nodeId, @PathParam(value="direction") DatabaseActions.RelationshipDirection direction) {
        try {
            return this.output.ok(this.actions.getNodeDegree(nodeId, direction, Collections.emptyList()));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="node/{nodeId}/degree/{direction}/{types}")
    public Response getNodeDegree(@PathParam(value="nodeId") long nodeId, @PathParam(value="direction") DatabaseActions.RelationshipDirection direction, @PathParam(value="types") AmpersandSeparatedCollection types) {
        try {
            return this.output.ok(this.actions.getNodeDegree(nodeId, direction, types));
        }
        catch (NodeNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="relationship/{relationshipId}/properties")
    public Response getAllRelationshipProperties(@PathParam(value="relationshipId") long relationshipId) {
        try {
            return this.output.response((Response.StatusType)Response.Status.OK, (Representation)this.actions.getAllRelationshipProperties(relationshipId));
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="relationship/{relationshipId}/properties/{key}")
    public Response getRelationshipProperty(@PathParam(value="relationshipId") long relationshipId, @PathParam(value="key") String key) {
        try {
            return this.output.ok(this.actions.getRelationshipProperty(relationshipId, key));
        }
        catch (NoSuchPropertyException | RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @PUT
    @Path(value="relationship/{relationshipId}/properties")
    @Consumes(value={"application/json"})
    public Response setAllRelationshipProperties(@PathParam(value="relationshipId") long relationshipId, String body) {
        try {
            this.actions.setAllRelationshipProperties(relationshipId, this.input.readMap(body, new String[0]));
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @PUT
    @Path(value="relationship/{relationshipId}/properties/{key}")
    @Consumes(value={"application/json"})
    public Response setRelationshipProperty(@PathParam(value="relationshipId") long relationshipId, @PathParam(value="key") String key, String body) {
        try {
            this.actions.setRelationshipProperty(relationshipId, key, this.input.readValue(body));
        }
        catch (BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @DELETE
    @Path(value="relationship/{relationshipId}/properties")
    public Response deleteAllRelationshipProperties(@PathParam(value="relationshipId") long relationshipId) {
        try {
            this.actions.removeAllRelationshipProperties(relationshipId);
        }
        catch (RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
        catch (PropertyValueException e) {
            return this.output.badRequest((Throwable)((Object)e));
        }
        return this.nothing();
    }

    @DELETE
    @Path(value="relationship/{relationshipId}/properties/{key}")
    public Response deleteRelationshipProperty(@PathParam(value="relationshipId") long relationshipId, @PathParam(value="key") String key) {
        try {
            this.actions.removeRelationshipProperty(relationshipId, key);
        }
        catch (NoSuchPropertyException | RelationshipNotFoundException e) {
            return this.output.notFound(e);
        }
        return this.nothing();
    }

    @GET
    @Path(value="index/node")
    public Response getNodeIndexRoot() {
        if (this.actions.getNodeIndexNames().length == 0) {
            return this.output.noContent();
        }
        return this.output.ok(this.actions.nodeIndexRoot());
    }

    @POST
    @Path(value="index/node")
    @Consumes(value={"application/json"})
    public Response jsonCreateNodeIndex(String json) {
        try {
            return this.output.created(this.actions.createNodeIndex(this.input.readMap(json, new String[0])));
        }
        catch (IllegalArgumentException | BadInputException e) {
            return this.output.badRequest(e);
        }
    }

    @GET
    @Path(value="index/relationship")
    public Response getRelationshipIndexRoot() {
        if (this.actions.getRelationshipIndexNames().length == 0) {
            return this.output.noContent();
        }
        return this.output.ok(this.actions.relationshipIndexRoot());
    }

    @POST
    @Path(value="index/relationship")
    @Consumes(value={"application/json"})
    public Response jsonCreateRelationshipIndex(String json) {
        try {
            return this.output.created(this.actions.createRelationshipIndex(this.input.readMap(json, new String[0])));
        }
        catch (IllegalArgumentException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/node/{indexName}")
    public Response getIndexedNodesByQuery(@PathParam(value="indexName") String indexName, @QueryParam(value="query") String query, @QueryParam(value="order") String order) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedNodesByQuery(indexName, query, order));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/auto/{type}")
    public Response getAutoIndexedNodesByQuery(@PathParam(value="type") String type, @QueryParam(value="query") String query) {
        try {
            if (type.equals(NODE_AUTO_INDEX_TYPE)) {
                return this.output.ok((Representation)this.actions.getAutoIndexedNodesByQuery(query));
            }
            if (type.equals(RELATIONSHIP_AUTO_INDEX_TYPE)) {
                return this.output.ok((Representation)this.actions.getAutoIndexedRelationshipsByQuery(query));
            }
            return this.output.badRequest(new RuntimeException("Unrecognized auto-index type, expected 'node' or 'relationship'"));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/node/{indexName}")
    @Consumes(value={"application/json"})
    public Response deleteNodeIndex(@PathParam(value="indexName") String indexName) {
        try {
            this.actions.removeNodeIndex(indexName);
            return this.output.noContent();
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
    }

    @DELETE
    @Path(value="index/relationship/{indexName}")
    @Consumes(value={"application/json"})
    public Response deleteRelationshipIndex(@PathParam(value="indexName") String indexName) {
        try {
            this.actions.removeRelationshipIndex(indexName);
            return this.output.noContent();
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
    }

    @POST
    @Path(value="index/node/{indexName}")
    @Consumes(value={"application/json"})
    public Response addToNodeIndex(@PathParam(value="indexName") String indexName, @QueryParam(value="unique") String unique, @QueryParam(value="uniqueness") String uniqueness, String postBody) {
        int otherHeaders = 512;
        int maximumSizeInBytes = this.config.getInt(ServerSettings.maximum_response_header_size.name()) - otherHeaders;
        try {
            switch (this.unique(unique, uniqueness)) {
                case GetOrCreate: {
                    Map entityBody = this.input.readMap(postBody, new String[]{"key", "value"});
                    String getOrCreateValue = String.valueOf(entityBody.get("value"));
                    if (getOrCreateValue.length() > maximumSizeInBytes) {
                        return this.valueTooBig();
                    }
                    Pair<IndexedEntityRepresentation, Boolean> result = this.actions.getOrCreateIndexedNode(indexName, String.valueOf(entityBody.get("key")), getOrCreateValue, this.extractNodeIdOrNull(this.getStringOrNull(entityBody, "uri")), RestfulGraphDatabase.getMapOrNull(entityBody, "properties"));
                    return (Boolean)result.other() != false ? this.output.created((Representation)result.first()) : this.output.okIncludeLocation((Representation)result.first());
                }
                case CreateOrFail: {
                    long idOfNodeAlreadyInIndex;
                    Map entityBody = this.input.readMap(postBody, new String[]{"key", "value"});
                    String createOrFailValue = String.valueOf(entityBody.get("value"));
                    if (createOrFailValue.length() > maximumSizeInBytes) {
                        return this.valueTooBig();
                    }
                    Pair<IndexedEntityRepresentation, Boolean> result = this.actions.getOrCreateIndexedNode(indexName, String.valueOf(entityBody.get("key")), createOrFailValue, this.extractNodeIdOrNull(this.getStringOrNull(entityBody, "uri")), RestfulGraphDatabase.getMapOrNull(entityBody, "properties"));
                    if (((Boolean)result.other()).booleanValue()) {
                        return this.output.created((Representation)result.first());
                    }
                    String uri = this.getStringOrNull(entityBody, "uri");
                    if (uri == null) {
                        return this.output.conflict((Representation)result.first());
                    }
                    long idOfNodeToBeIndexed = this.extractNodeId(uri);
                    if (idOfNodeToBeIndexed == (idOfNodeAlreadyInIndex = this.extractNodeId(((IndexedEntityRepresentation)result.first()).getIdentity()))) {
                        return this.output.created((Representation)result.first());
                    }
                    return this.output.conflict((Representation)result.first());
                }
            }
            Map entityBody = this.input.readMap(postBody, new String[]{"key", "value", "uri"});
            String value = String.valueOf(entityBody.get("value"));
            if (value.length() > maximumSizeInBytes) {
                return this.valueTooBig();
            }
            return this.output.created(this.actions.addToNodeIndex(indexName, String.valueOf(entityBody.get("key")), value, this.extractNodeId(entityBody.get("uri").toString())));
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (IllegalArgumentException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    private Response valueTooBig() {
        return Response.status((int)413).entity((Object)String.format("The property value provided was too large. The maximum size is currently set to %d bytes. You can configure this by setting the '%s' property.", this.config.getInt(ServerSettings.maximum_response_header_size.name()), ServerSettings.maximum_response_header_size.name())).build();
    }

    @POST
    @Path(value="index/relationship/{indexName}")
    public Response addToRelationshipIndex(@PathParam(value="indexName") String indexName, @QueryParam(value="unique") String unique, @QueryParam(value="uniqueness") String uniqueness, String postBody) {
        try {
            switch (this.unique(unique, uniqueness)) {
                case GetOrCreate: {
                    Map entityBody = this.input.readMap(postBody, new String[]{"key", "value"});
                    Pair<IndexedEntityRepresentation, Boolean> result = this.actions.getOrCreateIndexedRelationship(indexName, String.valueOf(entityBody.get("key")), String.valueOf(entityBody.get("value")), this.extractRelationshipIdOrNull(this.getStringOrNull(entityBody, "uri")), this.extractNodeIdOrNull(this.getStringOrNull(entityBody, "start")), this.getStringOrNull(entityBody, "type"), this.extractNodeIdOrNull(this.getStringOrNull(entityBody, "end")), RestfulGraphDatabase.getMapOrNull(entityBody, "properties"));
                    return (Boolean)result.other() != false ? this.output.created((Representation)result.first()) : this.output.ok((Representation)result.first());
                }
                case CreateOrFail: {
                    long idOfRelationshipAlreadyInIndex;
                    Map entityBody = this.input.readMap(postBody, new String[]{"key", "value"});
                    Pair<IndexedEntityRepresentation, Boolean> result = this.actions.getOrCreateIndexedRelationship(indexName, String.valueOf(entityBody.get("key")), String.valueOf(entityBody.get("value")), this.extractRelationshipIdOrNull(this.getStringOrNull(entityBody, "uri")), this.extractNodeIdOrNull(this.getStringOrNull(entityBody, "start")), this.getStringOrNull(entityBody, "type"), this.extractNodeIdOrNull(this.getStringOrNull(entityBody, "end")), RestfulGraphDatabase.getMapOrNull(entityBody, "properties"));
                    if (((Boolean)result.other()).booleanValue()) {
                        return this.output.created((Representation)result.first());
                    }
                    String uri = this.getStringOrNull(entityBody, "uri");
                    if (uri == null) {
                        return this.output.conflict((Representation)result.first());
                    }
                    long idOfRelationshipToBeIndexed = this.extractRelationshipId(uri);
                    if (idOfRelationshipToBeIndexed == (idOfRelationshipAlreadyInIndex = this.extractRelationshipId(((IndexedEntityRepresentation)result.first()).getIdentity()))) {
                        return this.output.created((Representation)result.first());
                    }
                    return this.output.conflict((Representation)result.first());
                }
            }
            Map entityBody = this.input.readMap(postBody, new String[]{"key", "value", "uri"});
            return this.output.created(this.actions.addToRelationshipIndex(indexName, String.valueOf(entityBody.get("key")), String.valueOf(entityBody.get("value")), this.extractRelationshipId(entityBody.get("uri").toString())));
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (IllegalArgumentException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    private UniqueIndexType unique(String uniqueParam, String uniquenessParam) {
        UniqueIndexType unique = UniqueIndexType.None;
        if (uniquenessParam == null || uniquenessParam.equals("")) {
            if ("".equals(uniqueParam) || Boolean.parseBoolean(uniqueParam)) {
                unique = UniqueIndexType.GetOrCreate;
            }
        } else if (UNIQUENESS_MODE_GET_OR_CREATE.equalsIgnoreCase(uniquenessParam)) {
            unique = UniqueIndexType.GetOrCreate;
        } else if (UNIQUENESS_MODE_CREATE_OR_FAIL.equalsIgnoreCase(uniquenessParam)) {
            unique = UniqueIndexType.CreateOrFail;
        }
        return unique;
    }

    private String getStringOrNull(Map<String, Object> map, String key) throws BadInputException {
        Object object = map.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return null;
        }
        throw new InvalidArgumentsException("\"" + key + "\" should be a string");
    }

    private static Map<String, Object> getMapOrNull(Map<String, Object> data, String key) throws BadInputException {
        Object object = data.get(key);
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == null) {
            return null;
        }
        throw new InvalidArgumentsException("\"" + key + "\" should be a map");
    }

    @GET
    @Path(value="index/node/{indexName}/{key}/{value}/{id}")
    public Response getNodeFromIndexUri(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="value") String value, @PathParam(value="id") long id) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedNode(indexName, key, value, id));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/relationship/{indexName}/{key}/{value}/{id}")
    public Response getRelationshipFromIndexUri(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="value") String value, @PathParam(value="id") long id) {
        return this.output.ok((Representation)this.actions.getIndexedRelationship(indexName, key, value, id));
    }

    @GET
    @Path(value="index/node/{indexName}/{key}/{value}")
    public Response getIndexedNodes(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="value") String value) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedNodes(indexName, key, value));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/auto/{type}/{key}/{value}")
    public Response getAutoIndexedNodes(@PathParam(value="type") String type, @PathParam(value="key") String key, @PathParam(value="value") String value) {
        try {
            if (type.equals(NODE_AUTO_INDEX_TYPE)) {
                return this.output.ok(this.actions.getAutoIndexedNodes(key, value));
            }
            if (type.equals(RELATIONSHIP_AUTO_INDEX_TYPE)) {
                return this.output.ok(this.actions.getAutoIndexedRelationships(key, value));
            }
            return this.output.badRequest(new RuntimeException("Unrecognized auto-index type, expected 'node' or 'relationship'"));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/node/{indexName}/{key}")
    public Response getIndexedNodesByQuery(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @QueryParam(value="query") String query, @PathParam(value="order") String order) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedNodesByQuery(indexName, key, query, order));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/relationship/{indexName}/{key}/{value}")
    public Response getIndexedRelationships(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="value") String value) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedRelationships(indexName, key, value));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/auto/{type}/status")
    public Response isAutoIndexerEnabled(@PathParam(value="type") String type) {
        return this.output.ok(this.actions.isAutoIndexerEnabled(type));
    }

    @PUT
    @Path(value="index/auto/{type}/status")
    public Response setAutoIndexerEnabled(@PathParam(value="type") String type, String enable) {
        this.actions.setAutoIndexerEnabled(type, Boolean.parseBoolean(enable));
        return this.output.ok(Representation.emptyRepresentation());
    }

    @GET
    @Path(value="index/auto/{type}/properties")
    public Response getAutoIndexedProperties(@PathParam(value="type") String type) {
        return this.output.ok(this.actions.getAutoIndexedProperties(type));
    }

    @POST
    @Path(value="index/auto/{type}/properties")
    public Response startAutoIndexingProperty(@PathParam(value="type") String type, String property) {
        this.actions.startAutoIndexingProperty(type, property);
        return this.output.ok(Representation.emptyRepresentation());
    }

    @DELETE
    @Path(value="index/auto/{type}/properties/{property}")
    public Response stopAutoIndexingProperty(@PathParam(value="type") String type, @PathParam(value="property") String property) {
        this.actions.stopAutoIndexingProperty(type, property);
        return this.output.ok(Representation.emptyRepresentation());
    }

    @GET
    @Path(value="index/relationship/{indexName}")
    public Response getIndexedRelationshipsByQuery(@PathParam(value="indexName") String indexName, @QueryParam(value="query") String query, @QueryParam(value="order") String order) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedRelationshipsByQuery(indexName, query, order));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @GET
    @Path(value="index/relationship/{indexName}/{key}")
    public Response getIndexedRelationshipsByQuery(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @QueryParam(value="query") String query, @QueryParam(value="order") String order) {
        try {
            return this.output.ok((Representation)this.actions.getIndexedRelationshipsByQuery(indexName, key, query, order));
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/node/{indexName}/{key}/{value}/{id}")
    public Response deleteFromNodeIndex(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="value") String value, @PathParam(value="id") long id) {
        try {
            this.actions.removeFromNodeIndex(indexName, key, value, id);
            return this.nothing();
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/node/{indexName}/{key}/{id}")
    public Response deleteFromNodeIndexNoValue(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="id") long id) {
        try {
            this.actions.removeFromNodeIndexNoValue(indexName, key, id);
            return this.nothing();
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/node/{indexName}/{id}")
    public Response deleteFromNodeIndexNoKeyValue(@PathParam(value="indexName") String indexName, @PathParam(value="id") long id) {
        try {
            this.actions.removeFromNodeIndexNoKeyValue(indexName, id);
            return this.nothing();
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/relationship/{indexName}/{key}/{value}/{id}")
    public Response deleteFromRelationshipIndex(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="value") String value, @PathParam(value="id") long id) {
        try {
            this.actions.removeFromRelationshipIndex(indexName, key, value, id);
            return this.nothing();
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/relationship/{indexName}/{key}/{id}")
    public Response deleteFromRelationshipIndexNoValue(@PathParam(value="indexName") String indexName, @PathParam(value="key") String key, @PathParam(value="id") long id) {
        try {
            this.actions.removeFromRelationshipIndexNoValue(indexName, key, id);
            return this.nothing();
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @DELETE
    @Path(value="index/relationship/{indexName}/{id}")
    public Response deleteFromRelationshipIndex(@PathParam(value="indexName") String indexName, @PathParam(value="id") long id) {
        try {
            this.actions.removeFromRelationshipIndexNoKeyValue(indexName, id);
            return this.nothing();
        }
        catch (UnsupportedOperationException e) {
            return this.output.methodNotAllowed(e);
        }
        catch (NotFoundException nfe) {
            return this.output.notFound(nfe);
        }
        catch (Exception e) {
            return this.output.serverError(e);
        }
    }

    @POST
    @Path(value="node/{nodeId}/traverse/{returnType}")
    public Response traverse(@PathParam(value="nodeId") long startNode, @PathParam(value="returnType") TraverserReturnType returnType, String body) {
        try {
            return this.output.ok((Representation)this.actions.traverse(startNode, this.input.readMap(body, new String[0]), returnType));
        }
        catch (EvaluationException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (NotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @DELETE
    @Path(value="node/{nodeId}/paged/traverse/{returnType}/{traverserId}")
    public Response removePagedTraverser(@PathParam(value="traverserId") String traverserId) {
        if (this.actions.removePagedTraverse(traverserId)) {
            return this.output.ok();
        }
        return this.output.notFound();
    }

    @GET
    @Path(value="node/{nodeId}/paged/traverse/{returnType}/{traverserId}")
    public Response pagedTraverse(@PathParam(value="traverserId") String traverserId, @PathParam(value="returnType") TraverserReturnType returnType) {
        try {
            return this.output.ok((Representation)this.actions.pagedTraverse(traverserId, returnType));
        }
        catch (EvaluationException e) {
            return this.output.badRequest(e);
        }
        catch (NotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @POST
    @Path(value="node/{nodeId}/paged/traverse/{returnType}")
    public Response createPagedTraverser(@PathParam(value="nodeId") long startNode, @PathParam(value="returnType") TraverserReturnType returnType, @QueryParam(value="pageSize") @DefaultValue(value="50") int pageSize, @QueryParam(value="leaseTime") @DefaultValue(value="60") int leaseTimeInSeconds, String body) {
        try {
            this.validatePageSize(pageSize);
            this.validateLeaseTime(leaseTimeInSeconds);
            String traverserId = this.actions.createPagedTraverser(startNode, this.input.readMap(body, new String[0]), pageSize, leaseTimeInSeconds);
            URI uri = new URI("node/" + startNode + "/paged/traverse/" + (Object)((Object)returnType) + "/" + traverserId);
            return this.output.created(new ListEntityRepresentation(this.actions.pagedTraverse(traverserId, returnType), uri.normalize()));
        }
        catch (EvaluationException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (NotFoundException e) {
            return this.output.notFound(e);
        }
        catch (URISyntaxException e) {
            return this.output.serverError(e);
        }
    }

    private void validateLeaseTime(int leaseTimeInSeconds) throws BadInputException {
        if (leaseTimeInSeconds < 1) {
            throw new InvalidArgumentsException("Lease time less than 1 second is not supported");
        }
    }

    private void validatePageSize(int pageSize) throws BadInputException {
        if (pageSize < 1) {
            throw new InvalidArgumentsException("Page size less than 1 is not permitted");
        }
    }

    @POST
    @Path(value="node/{nodeId}/path")
    public Response singlePath(@PathParam(value="nodeId") long startNode, String body) {
        try {
            Map description = this.input.readMap(body, new String[0]);
            long endNode = this.extractNodeId((String)description.get("to"));
            return this.output.ok((Representation)this.actions.findSinglePath(startNode, endNode, description));
        }
        catch (ClassCastException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (NotFoundException e) {
            return this.output.notFound(e);
        }
    }

    @POST
    @Path(value="node/{nodeId}/paths")
    public Response allPaths(@PathParam(value="nodeId") long startNode, String body) {
        try {
            Map description = this.input.readMap(body, new String[0]);
            long endNode = this.extractNodeId((String)description.get("to"));
            return this.output.ok((Representation)this.actions.findPaths(startNode, endNode, description));
        }
        catch (ClassCastException | BadInputException e) {
            return this.output.badRequest(e);
        }
    }

    @POST
    @Path(value="schema/index/{label}")
    public Response createSchemaIndex(@PathParam(value="label") String labelName, String body) {
        try {
            Map data = this.input.readMap(body, new String[]{"property_keys"});
            Iterable<String> singlePropertyKey = this.singleOrList(data, "property_keys");
            if (singlePropertyKey == null) {
                return this.output.badRequest(new IllegalArgumentException("Supply single property key or list of property keys"));
            }
            return this.output.ok((Representation)this.actions.createSchemaIndex(labelName, singlePropertyKey));
        }
        catch (UnsupportedOperationException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    private Iterable<String> singleOrList(Map<String, Object> data, String key) {
        Object propertyKeys = data.get(key);
        List<String> singlePropertyKey = null;
        if (propertyKeys instanceof List) {
            singlePropertyKey = (List<String>)propertyKeys;
        } else if (propertyKeys instanceof String) {
            singlePropertyKey = Collections.singletonList((String)propertyKeys);
        }
        return singlePropertyKey;
    }

    @DELETE
    @Path(value="schema/index/{label}/{property}")
    public Response dropSchemaIndex(@PathParam(value="label") String labelName, @PathParam(value="property") AmpersandSeparatedCollection properties) {
        if (properties.size() != 1) {
            return this.output.badRequest(new IllegalArgumentException("Single property key assumed"));
        }
        String property = (String)Iterables.single((Iterable)properties);
        try {
            if (this.actions.dropSchemaIndex(labelName, property)) {
                return this.nothing();
            }
            return this.output.notFound();
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    @GET
    @Path(value="schema/index")
    public Response getSchemaIndexes() {
        return this.output.ok((Representation)this.actions.getSchemaIndexes());
    }

    @GET
    @Path(value="schema/index/{label}")
    public Response getSchemaIndexesForLabel(@PathParam(value="label") String labelName) {
        return this.output.ok((Representation)this.actions.getSchemaIndexes(labelName));
    }

    @POST
    @Path(value="schema/constraint/{label}/uniqueness")
    public Response createPropertyUniquenessConstraint(@PathParam(value="label") String labelName, String body) {
        try {
            Map data = this.input.readMap(body, new String[]{"property_keys"});
            Iterable<String> singlePropertyKey = this.singleOrList(data, "property_keys");
            if (singlePropertyKey == null) {
                return this.output.badRequest(new IllegalArgumentException("Supply single property key or list of property keys"));
            }
            return this.output.ok((Representation)this.actions.createPropertyUniquenessConstraint(labelName, singlePropertyKey));
        }
        catch (UnsupportedOperationException | BadInputException e) {
            return this.output.badRequest(e);
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    @DELETE
    @Path(value="schema/constraint/{label}/uniqueness/{property}")
    public Response dropPropertyUniquenessConstraint(@PathParam(value="label") String labelName, @PathParam(value="property") AmpersandSeparatedCollection properties) {
        try {
            if (this.actions.dropPropertyUniquenessConstraint(labelName, properties)) {
                return this.nothing();
            }
            return this.output.notFound();
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    @DELETE
    @Path(value="schema/constraint/{label}/existence/{property}")
    public Response dropNodePropertyExistenceConstraint(@PathParam(value="label") String labelName, @PathParam(value="property") AmpersandSeparatedCollection properties) {
        try {
            if (this.actions.dropNodePropertyExistenceConstraint(labelName, properties)) {
                return this.nothing();
            }
            return this.output.notFound();
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    @DELETE
    @Path(value="schema/relationship/constraint/{type}/existence/{property}")
    public Response dropRelationshipPropertyExistenceConstraint(@PathParam(value="type") String typeName, @PathParam(value="property") AmpersandSeparatedCollection properties) {
        try {
            if (this.actions.dropRelationshipPropertyExistenceConstraint(typeName, properties)) {
                return this.nothing();
            }
            return this.output.notFound();
        }
        catch (ConstraintViolationException e) {
            return this.output.conflict(e);
        }
    }

    @GET
    @Path(value="schema/constraint")
    public Response getSchemaConstraints() {
        return this.output.ok((Representation)this.actions.getConstraints());
    }

    @GET
    @Path(value="schema/constraint/{label}")
    public Response getSchemaConstraintsForLabel(@PathParam(value="label") String labelName) {
        return this.output.ok((Representation)this.actions.getLabelConstraints(labelName));
    }

    @GET
    @Path(value="schema/constraint/{label}/uniqueness")
    public Response getSchemaConstraintsForLabelAndUniqueness(@PathParam(value="label") String labelName) {
        return this.output.ok(this.actions.getLabelUniquenessConstraints(labelName));
    }

    @GET
    @Path(value="schema/constraint/{label}/existence")
    public Response getSchemaConstraintsForLabelAndExistence(@PathParam(value="label") String labelName) {
        return this.output.ok(this.actions.getLabelExistenceConstraints(labelName));
    }

    @GET
    @Path(value="schema/relationship/constraint/{type}/existence")
    public Response getSchemaConstraintsForRelationshipTypeAndExistence(@PathParam(value="type") String typeName) {
        return this.output.ok(this.actions.getRelationshipTypeExistenceConstraints(typeName));
    }

    @GET
    @Path(value="schema/constraint/{label}/uniqueness/{property}")
    public Response getSchemaConstraintsForLabelAndPropertyUniqueness(@PathParam(value="label") String labelName, @PathParam(value="property") AmpersandSeparatedCollection propertyKeys) {
        try {
            ListRepresentation constraints = this.actions.getPropertyUniquenessConstraint(labelName, propertyKeys);
            return this.output.ok((Representation)constraints);
        }
        catch (IllegalArgumentException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="schema/constraint/{label}/existence/{property}")
    public Response getSchemaConstraintsForLabelAndPropertyExistence(@PathParam(value="label") String labelName, @PathParam(value="property") AmpersandSeparatedCollection propertyKeys) {
        try {
            ListRepresentation constraints = this.actions.getNodePropertyExistenceConstraint(labelName, propertyKeys);
            return this.output.ok((Representation)constraints);
        }
        catch (IllegalArgumentException e) {
            return this.output.notFound(e);
        }
    }

    @GET
    @Path(value="schema/relationship/constraint/{type}/existence/{property}")
    public Response getSchemaConstraintsForRelationshipTypeAndPropertyExistence(@PathParam(value="type") String typeName, @PathParam(value="property") AmpersandSeparatedCollection propertyKeys) {
        try {
            ListRepresentation constraints = this.actions.getRelationshipPropertyExistenceConstraint(typeName, propertyKeys);
            return this.output.ok((Representation)constraints);
        }
        catch (IllegalArgumentException e) {
            return this.output.notFound(e);
        }
    }

    private static enum UniqueIndexType {
        None,
        GetOrCreate,
        CreateOrFail;

    }

    public static class AmpersandSeparatedCollection
    extends LinkedHashSet<String> {
        public AmpersandSeparatedCollection(String path) {
            for (String e : path.split("&")) {
                if (e.trim().length() <= 0) continue;
                this.add(e);
            }
        }
    }
}

