/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CorsFilter
implements Filter {
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Enumeration requestHeaderEnumeration;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        Enumeration requestMethodEnumeration = request.getHeaders(ACCESS_CONTROL_REQUEST_METHOD);
        if (requestMethodEnumeration != null) {
            while (requestMethodEnumeration.hasMoreElements()) {
                String requestMethod = (String)requestMethodEnumeration.nextElement();
                response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, requestMethod);
            }
        }
        if ((requestHeaderEnumeration = request.getHeaders(ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            while (requestHeaderEnumeration.hasMoreElements()) {
                String requestHeader = (String)requestHeaderEnumeration.nextElement();
                response.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, requestHeader);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

