/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.server.rest.security.SecurityFilter;
import org.neo4j.server.rest.security.SecurityRule;

public class SecurityFilterTest {
    @Test
    public void shouldPassThroughRequestToAnUnsecuredPath() throws Exception {
        SecurityRule rule = (SecurityRule)Mockito.mock(SecurityRule.class);
        Mockito.when((Object)rule.forUriPath()).thenReturn((Object)"/some-path");
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        SecurityFilter securityFilter = new SecurityFilter(rule, new SecurityRule[0]);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/some-other-path");
        securityFilter.doFilter((ServletRequest)request, (ServletResponse)Mockito.mock(HttpServletResponse.class), filterChain);
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)ArgumentMatchers.any(HttpServletRequest.class), (ServletResponse)ArgumentMatchers.any(HttpServletResponse.class));
    }

    @Test
    public void shouldActivateRuleThatRejectsTheRequestForAMatchingPath() throws Exception {
        SecurityRule rule = (SecurityRule)Mockito.mock(SecurityRule.class);
        Mockito.when((Object)rule.forUriPath()).thenReturn((Object)"/some-path");
        Mockito.when((Object)rule.isAuthorized((HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class))).thenReturn((Object)false);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        SecurityFilter securityFilter = new SecurityFilter(rule, new SecurityRule[0]);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/some-path");
        securityFilter.doFilter((ServletRequest)request, (ServletResponse)Mockito.mock(HttpServletResponse.class), filterChain);
        ((FilterChain)Mockito.verify((Object)filterChain, (VerificationMode)Mockito.times((int)0))).doFilter((ServletRequest)ArgumentMatchers.any(HttpServletRequest.class), (ServletResponse)ArgumentMatchers.any(HttpServletResponse.class));
    }

    @Test
    public void shouldActivateRuleThatAcceptsTheRequestForAMatchingPath() throws Exception {
        SecurityRule rule = (SecurityRule)Mockito.mock(SecurityRule.class);
        Mockito.when((Object)rule.forUriPath()).thenReturn((Object)"/some-path");
        Mockito.when((Object)rule.isAuthorized((HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class))).thenReturn((Object)true);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        SecurityFilter securityFilter = new SecurityFilter(rule, new SecurityRule[0]);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/some-path");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        securityFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void shouldRemoveRules() throws Exception {
        SecurityRule securityRule1 = (SecurityRule)Mockito.mock(SecurityRule.class);
        Mockito.when((Object)securityRule1.forUriPath()).thenReturn((Object)"/securityRule1");
        SecurityRule securityRule2 = (SecurityRule)Mockito.mock(SecurityRule.class);
        Mockito.when((Object)securityRule2.forUriPath()).thenReturn((Object)"/securityRule2");
        SecurityFilter securityFilter = new SecurityFilter(securityRule1, new SecurityRule[]{securityRule2});
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        securityFilter.destroy();
        securityFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        ((FilterChain)Mockito.verify((Object)filterChain)).doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

