/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.server.ServerHolder;

public class SharedServerTestBase {
    private static NeoServer server;
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    protected static NeoServer server() {
        return server;
    }

    @BeforeClass
    public static void allocateServer() throws Throwable {
        System.setProperty("org.neo4j.useInsecureCertificateGeneration", "true");
        SuppressOutput.suppressAll().call(() -> {
            ServerHolder.setServerBuilderProperty(GraphDatabaseSettings.cypher_hints_error.name(), "true");
            ServerHolder.setServerBuilderProperty(GraphDatabaseSettings.transaction_timeout.name(), "120s");
            server = ServerHolder.allocate();
            ServerHelper.cleanTheDatabase(server);
            return null;
        });
    }

    @AfterClass
    public static void releaseServer() throws Exception {
        try {
            SuppressOutput.suppressAll().call(() -> {
                ServerHolder.release(server);
                return null;
            });
        }
        finally {
            server = null;
        }
    }
}

