/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.paging;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.server.rest.paging.PagedTraverser;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class PagedTraverserTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private static final int LIST_LENGTH = 100;
    private Node startNode;

    @Before
    public void clearDb() {
        this.createLinkedList(100, (GraphDatabaseService)this.dbRule.getGraphDatabaseAPI());
    }

    private void createLinkedList(int listLength, GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node previous = null;
            for (int i = 0; i < listLength; ++i) {
                Node current = db.createNode();
                if (previous != null) {
                    previous.createRelationshipTo(current, RelationshipType.withName((String)"NEXT"));
                } else {
                    this.startNode = current;
                }
                previous = current;
            }
            tx.success();
        }
    }

    @Test
    public void shouldPageThroughResultsForWhollyDivisiblePageSize() {
        Traverser myTraverser = this.simpleListTraverser();
        PagedTraverser traversalPager = new PagedTraverser(myTraverser, 10);
        int iterations = this.iterateThroughPagedTraverser(traversalPager);
        Assert.assertEquals((long)10L, (long)iterations);
        Assert.assertNull((Object)traversalPager.next());
    }

    private int iterateThroughPagedTraverser(PagedTraverser traversalPager) {
        try (Transaction transaction = this.dbRule.getGraphDatabaseAPI().beginTx();){
            int count = 0;
            for (List paths : traversalPager) {
                ++count;
            }
            transaction.success();
            int n = count;
            return n;
        }
    }

    @Test
    public void shouldPageThroughResultsForNonWhollyDivisiblePageSize() {
        int awkwardPageSize = 7;
        Traverser myTraverser = this.simpleListTraverser();
        PagedTraverser traversalPager = new PagedTraverser(myTraverser, awkwardPageSize);
        int iterations = this.iterateThroughPagedTraverser(traversalPager);
        Assert.assertEquals((long)15L, (long)iterations);
        Assert.assertNull((Object)traversalPager.next());
    }

    private Traverser simpleListTraverser() {
        return this.dbRule.traversalDescription().expand(PathExpanders.forTypeAndDirection((RelationshipType)RelationshipType.withName((String)"NEXT"), (Direction)Direction.OUTGOING)).depthFirst().uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).traverse(this.startNode);
    }
}

