/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.server.rest.domain.EvaluationException;
import org.neo4j.server.rest.web.ScriptExecutionMode;
import org.neo4j.server.scripting.javascript.GlobalJavascriptInitializer;
import org.neo4j.server.scripting.javascript.JavascriptExecutor;

public class TestJavascriptSecurityRestrictions {
    public static void methodThatShouldNotBeCallable() {
    }

    @BeforeClass
    public static void doBullshitGlobalStateCrap() {
        GlobalJavascriptInitializer.initialize((ScriptExecutionMode)ScriptExecutionMode.SANDBOXED);
    }

    @Test
    public void shouldBeAbleToAccessWhiteListedThings() {
        String classThatShouldBeInaccessible = TestJavascriptSecurityRestrictions.class.getName();
        JavascriptExecutor executor = new JavascriptExecutor(Evaluation.class.getName() + ".INCLUDE_AND_CONTINUE;");
        Object result = executor.execute(null);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Evaluation.class)));
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)Evaluation.INCLUDE_AND_CONTINUE));
    }

    @Test(expected=EvaluationException.class)
    public void shouldNotBeAbleToImportUnsafeClasses() {
        String classThatShouldBeInaccessible = TestJavascriptSecurityRestrictions.class.getName();
        JavascriptExecutor executor = new JavascriptExecutor(classThatShouldBeInaccessible + ".methodThatShouldNotBeCallable();");
        executor.execute(null);
    }

    @Test(expected=EvaluationException.class)
    public void shouldNotBeAbleToUseReflectionToInstantiateThings() {
        JavascriptExecutor executor = new JavascriptExecutor(Evaluation.class.getName() + ".getClass().getClassLoader();");
        executor.execute(null);
    }
}

