/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.server.rest.domain.EvaluationException;
import org.neo4j.server.rest.web.ScriptExecutionMode;
import org.neo4j.server.scripting.ScriptExecutor;
import org.neo4j.server.scripting.ScriptExecutorFactoryRepository;
import org.neo4j.server.scripting.javascript.JavascriptExecutor;

public class EvaluatorFactory {
    private static final String BUILTIN = "builtin";
    private static final String KEY_LANGUAGE = "language";
    private static final String KEY_BODY = "body";
    private static final String KEY_NAME = "name";
    private final ScriptExecutorFactoryRepository factoryRepo;

    public EvaluatorFactory(ScriptExecutionMode executionMode) {
        HashMap<String, ScriptExecutor.Factory> languages = new HashMap<String, ScriptExecutor.Factory>();
        languages.put("javascript", new JavascriptExecutor.Factory(executionMode));
        this.factoryRepo = new ScriptExecutorFactoryRepository(languages);
    }

    public Evaluator pruneEvaluator(Map<String, Object> description) {
        if (EvaluatorFactory.refersToBuiltInEvaluator(description)) {
            return EvaluatorFactory.builtInPruneEvaluator(description);
        }
        return new ScriptedPruneEvaluator(this.getOrCreateExecutorFor(description));
    }

    public Evaluator returnFilter(Map<String, Object> description) {
        if (EvaluatorFactory.refersToBuiltInEvaluator(description)) {
            return EvaluatorFactory.builtInReturnFilter(description);
        }
        return new ScriptedReturnEvaluator(this.getOrCreateExecutorFor(description));
    }

    private ScriptExecutor getOrCreateExecutorFor(Map<String, Object> description) {
        String language = (String)description.get(KEY_LANGUAGE);
        String body = (String)description.get(KEY_BODY);
        return this.factoryRepo.getFactory(language).createExecutorForScript(body);
    }

    private static boolean refersToBuiltInEvaluator(Map<String, Object> description) {
        String language = (String)description.get(KEY_LANGUAGE);
        return language.equals(BUILTIN);
    }

    private static Evaluator builtInPruneEvaluator(Map<String, Object> description) {
        String name = (String)description.get(KEY_NAME);
        if (name.equalsIgnoreCase("none")) {
            return null;
        }
        throw new EvaluationException("Unrecognized prune evaluator name '" + name + "'");
    }

    private static Evaluator builtInReturnFilter(Map<String, Object> description) {
        String name = (String)description.get(KEY_NAME);
        if (name.equalsIgnoreCase("all")) {
            return null;
        }
        if (name.equalsIgnoreCase("all_but_start_node")) {
            return Evaluators.excludeStartPosition();
        }
        throw new EvaluationException("Unrecognized return evaluator name '" + name + "'");
    }

    private static class ScriptedReturnEvaluator
    extends ScriptedEvaluator
    implements Evaluator {
        ScriptedReturnEvaluator(ScriptExecutor executor) {
            super(executor);
        }

        public Evaluation evaluate(Path path) {
            return Evaluation.ofIncludes((boolean)this.evalPosition(path));
        }
    }

    private static class ScriptedPruneEvaluator
    extends ScriptedEvaluator
    implements Evaluator {
        ScriptedPruneEvaluator(ScriptExecutor executor) {
            super(executor);
        }

        public Evaluation evaluate(Path path) {
            return Evaluation.ofContinues((!this.evalPosition(path) ? 1 : 0) != 0);
        }
    }

    private static abstract class ScriptedEvaluator {
        private final ScriptExecutor executor;
        private final Map<String, Object> scriptContext = new HashMap<String, Object>(1);

        ScriptedEvaluator(ScriptExecutor executor) {
            this.executor = executor;
        }

        protected boolean evalPosition(Path path) {
            this.scriptContext.put("position", path);
            Object out = this.executor.execute(this.scriptContext);
            if (out instanceof Boolean) {
                return (Boolean)out;
            }
            throw new EvaluationException("Provided script did not return a boolean value.");
        }
    }
}

