/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import com.sun.jersey.api.client.ClientResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.security.CommunityServerTestBase;
import org.neo4j.server.web.HttpMethod;
import org.neo4j.test.server.HTTP;

public class AuthorizationCorsIT
extends CommunityServerTestBase {
    @Test
    public void shouldAddCorsHeaderWhenAuthDisabled() throws Exception {
        this.startServer(false);
        HTTP.Response response = this.runQuery("authDisabled", "authDisabled");
        Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertThat((Object)response.content().toString(), (Matcher)Matchers.containsString((String)"42"));
    }

    @Test
    public void shouldAddCorsHeaderWhenAuthEnabledAndPasswordChangeRequired() throws Exception {
        this.startServer(true);
        HTTP.Response response = this.runQuery("neo4j", "neo4j");
        Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertThat((Object)response.content().toString(), (Matcher)Matchers.containsString((String)"password_change"));
    }

    @Test
    public void shouldAddCorsHeaderWhenAuthEnabledAndPasswordChangeNotRequired() throws Exception {
        this.startServer(true);
        HTTP.Response passwordChangeResponse = this.changePassword("neo4j", "neo4j", "newPassword");
        Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)passwordChangeResponse.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(passwordChangeResponse);
        HTTP.Response queryResponse = this.runQuery("neo4j", "newPassword");
        Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)queryResponse.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(queryResponse);
        Assert.assertThat((Object)queryResponse.content().toString(), (Matcher)Matchers.containsString((String)"42"));
    }

    @Test
    public void shouldAddCorsHeaderWhenAuthEnabledAndIncorrectPassword() throws Exception {
        this.startServer(true);
        HTTP.Response response = this.runQuery("neo4j", "wrongPassword");
        Assert.assertEquals((long)ClientResponse.Status.UNAUTHORIZED.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertThat((Object)response.content().toString(), (Matcher)Matchers.containsString((String)"Neo.ClientError.Security.Unauthorized"));
    }

    @Test
    public void shouldAddCorsMethodsHeader() throws Exception {
        this.startServer(false);
        this.testCorsAllowMethods(HttpMethod.POST);
        this.testCorsAllowMethods(HttpMethod.GET);
        this.testCorsAllowMethods(HttpMethod.PATCH);
        this.testCorsAllowMethods(HttpMethod.DELETE);
    }

    @Test
    public void shouldAddCorsRequestHeaders() throws Exception {
        this.startServer(false);
        HTTP.Builder requestBuilder = this.requestWithHeaders("authDisabled", "authDisabled").withHeaders("Access-Control-Request-Headers", "Accept, X-Not-Accept");
        HTTP.Response response = this.runQuery(requestBuilder);
        Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertEquals((Object)"Accept, X-Not-Accept", (Object)response.header("Access-Control-Allow-Headers"));
    }

    private void testCorsAllowMethods(HttpMethod method) throws Exception {
        HTTP.Builder requestBuilder = this.requestWithHeaders("authDisabled", "authDisabled").withHeaders("Access-Control-Request-Method", method.toString());
        HTTP.Response response = this.runQuery(requestBuilder);
        Assert.assertEquals((long)ClientResponse.Status.OK.getStatusCode(), (long)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assert.assertEquals((Object)method, (Object)HttpMethod.valueOf((String)response.header("Access-Control-Allow-Methods")));
    }

    private HTTP.Response changePassword(String username, String oldPassword, String newPassword) {
        HTTP.RawPayload passwordChange = HTTP.RawPayload.quotedJson("{'password': '" + newPassword + "'}");
        return this.requestWithHeaders(username, oldPassword).POST(this.passwordURL(username), passwordChange);
    }

    private HTTP.Response runQuery(String username, String password) {
        return this.runQuery(this.requestWithHeaders(username, password));
    }

    private HTTP.Response runQuery(HTTP.Builder requestBuilder) {
        HTTP.RawPayload statements = HTTP.RawPayload.quotedJson("{'statements': [{'statement': 'RETURN 42'}]}");
        return requestBuilder.POST(this.txCommitURL(), statements);
    }

    private HTTP.Builder requestWithHeaders(String username, String password) {
        return HTTP.withHeaders("Accept", "application/json; charset=UTF-8", "Content-Type", "application/json", "Authorization", this.basicAuthHeader(username, password));
    }

    private static void assertCorsHeaderPresent(HTTP.Response response) {
        Assert.assertEquals((Object)"*", (Object)response.header("Access-Control-Allow-Origin"));
    }
}

