/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.DefaultFormat;
import org.neo4j.server.rest.repr.MediaTypeNotSupportedException;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class DefaultFormatTest {
    private DefaultFormat input;

    @Before
    public void setUp() {
        JsonFormat inner = new JsonFormat();
        ArrayList supported = new ArrayList();
        MediaType requested = MediaType.APPLICATION_JSON_TYPE;
        this.input = new DefaultFormat((RepresentationFormat)inner, supported, new MediaType[]{requested});
    }

    @Test
    public void canReadEmptyMap() throws Exception {
        Map map = this.input.readMap("{}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((String)"map is not empty", (boolean)map.isEmpty());
    }

    @Test
    public void canReadMapWithTwoValues() throws Exception {
        Map map = this.input.readMap("{\"key1\":\"value1\",     \"key2\":\"value11\"}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)"key1", (Object)"value1"));
        Assert.assertThat((Object)map, (Matcher)Matchers.hasEntry((Object)"key2", (Object)"value11"));
        Assert.assertTrue((String)"map contained extra values", (map.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void canReadMapWithNestedMap() throws Exception {
        Map map = this.input.readMap("{\"nested\": {\"key\": \"valuable\"}}", new String[0]);
        Assert.assertNotNull((Object)map);
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"nested"));
        Assert.assertTrue((String)"map contained extra values", (map.size() == 1 ? 1 : 0) != 0);
        Object nested = map.get("nested");
        Assert.assertThat(nested, (Matcher)Matchers.instanceOf(Map.class));
        Map nestedMap = (Map)nested;
        Assert.assertThat((Object)nestedMap, (Matcher)Matchers.hasEntry((Object)"key", (Object)"valuable"));
    }

    @Test(expected=MediaTypeNotSupportedException.class)
    public void failsWithTheCorrectExceptionWhenGettingTheWrongInput() {
        this.input.readValue("<xml />");
    }

    @Test(expected=MediaTypeNotSupportedException.class)
    public void failsWithTheCorrectExceptionWhenGettingTheWrongInput2() throws BadInputException {
        this.input.readMap("<xml />", new String[0]);
    }

    @Test(expected=MediaTypeNotSupportedException.class)
    public void failsWithTheCorrectExceptionWhenGettingTheWrongInput3() {
        this.input.readUri("<xml />");
    }
}

