/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.function.Function;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class IndexDefinitionRepresentation
extends MappingRepresentation {
    private final IndexDefinition indexDefinition;
    private final IndexPopulationProgress indexPopulationProgress;
    private final Schema.IndexState indexState;

    public IndexDefinitionRepresentation(IndexDefinition indexDefinition) {
        this(indexDefinition, Schema.IndexState.ONLINE, IndexPopulationProgress.DONE);
    }

    public IndexDefinitionRepresentation(IndexDefinition indexDefinition, Schema.IndexState indexState, IndexPopulationProgress indexPopulationProgress) {
        super(RepresentationType.INDEX_DEFINITION);
        this.indexDefinition = indexDefinition;
        this.indexPopulationProgress = indexPopulationProgress;
        this.indexState = indexState;
    }

    protected void serialize(MappingSerializer serializer) {
        serializer.putString("label", this.indexDefinition.getLabel().name());
        Function<String, Representation> converter = ValueRepresentation::string;
        Iterable propertyKeyRepresentations = Iterables.map(converter, (Iterable)this.indexDefinition.getPropertyKeys());
        serializer.putList("property_keys", new ListRepresentation(RepresentationType.STRING, propertyKeyRepresentations));
        if (this.indexState == Schema.IndexState.POPULATING) {
            serializer.putString("state", this.indexState.name());
            serializer.putString("population_progress", String.format("%1.0f%%", Float.valueOf(this.indexPopulationProgress.getCompletedPercentage())));
        }
    }
}

