/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.modules.AuthorizationModule;
import org.neo4j.server.modules.ConsoleModule;
import org.neo4j.server.modules.DBMSModule;
import org.neo4j.server.modules.ManagementApiModule;
import org.neo4j.server.modules.Neo4jBrowserModule;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.SecurityRulesModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.rest.management.AdvertisableService;
import org.neo4j.server.rest.management.JmxService;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.server.web.WebServer;

public class CommunityNeoServer
extends AbstractNeoServer {
    protected static final LifecycleManagingDatabase.GraphFactory COMMUNITY_FACTORY = (config, dependencies) -> {
        File storeDir = (File)config.get(GraphDatabaseSettings.database_path);
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new).newFacade(storeDir, config, dependencies);
    };

    public CommunityNeoServer(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        this(config, LifecycleManagingDatabase.lifecycleManagingDatabase(COMMUNITY_FACTORY), dependencies, logProvider);
    }

    public CommunityNeoServer(Config config, Database.Factory dbFactory, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        super(config, dbFactory, dependencies, logProvider);
    }

    @Override
    protected Iterable<ServerModule> createServerModules() {
        return Arrays.asList(new DBMSModule(this.webServer, this.getConfig()), new RESTApiModule(this.webServer, this.getConfig(), this.getDependencyResolver(), this.logProvider), new ManagementApiModule(this.webServer, this.getConfig()), new ThirdPartyJAXRSModule(this.webServer, this.getConfig(), this.logProvider, this), new ConsoleModule(this.webServer, this.getConfig()), new Neo4jBrowserModule(this.webServer), this.createAuthorizationModule(), new SecurityRulesModule(this.webServer, this.getConfig(), this.logProvider));
    }

    @Override
    protected WebServer createWebServer() {
        return new Jetty9WebServer(this.logProvider, this.getConfig());
    }

    @Override
    public Iterable<AdvertisableService> getServices() {
        ArrayList<AdvertisableService> toReturn = new ArrayList<AdvertisableService>(3);
        toReturn.add(new ConsoleService(null, null, this.logProvider, null));
        toReturn.add(new JmxService(null, null));
        return toReturn;
    }

    protected AuthorizationModule createAuthorizationModule() {
        return new AuthorizationModule(this.webServer, this.authManagerSupplier, this.logProvider, this.getConfig(), this.getUriWhitelist());
    }
}

