/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;
import org.neo4j.test.server.InsecureTrustManager;

public class HttpsAccessIT
extends ExclusiveServerTestBase {
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Before
    public void startServer() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        this.server = CommunityServerBuilder.serverOnRandomPorts().withHttpsEnabled().usingDataDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        TrustManager[] trustAllCerts = new TrustManager[]{new InsecureTrustManager()};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    @Test
    public void serverShouldSupportSsl() {
        this.server.start();
        Assert.assertThat((Object)this.server.httpsIsEnabled(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)HTTP.GET(this.server.baseUri().toString()).status(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void txEndpointShouldReplyWithHttpsWhenItReturnsURLs() throws Exception {
        this.server.start();
        String baseUri = this.server.baseUri().toString();
        HTTP.Response response = HTTP.POST(baseUri + "db/data/transaction", HTTP.RawPayload.quotedJson("{'statements':[]}"));
        Assert.assertThat((Object)response.location(), (Matcher)CoreMatchers.startsWith((String)baseUri));
        Assert.assertThat((Object)response.get("commit").asText(), (Matcher)CoreMatchers.startsWith((String)baseUri));
    }
}

