/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.repr.formats.UrlFormFormat;

public class UrlFormFormatTest {
    @Test
    public void shouldParseEmptyMap() throws Exception {
        UrlFormFormat format = new UrlFormFormat();
        Map map = format.readMap("", new String[0]);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void canParseSingleKeyMap() throws Exception {
        UrlFormFormat format = new UrlFormFormat();
        Map map = format.readMap("var=A", new String[0]);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(map.get("var"), (Matcher)CoreMatchers.is((Object)"A"));
    }

    @Test
    public void canParseListsInMaps() throws Exception {
        UrlFormFormat format = new UrlFormFormat();
        Map map = format.readMap("var=A&var=B", new String[0]);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(((List)map.get("var")).get(0), (Matcher)CoreMatchers.is((Object)"A"));
        MatcherAssert.assertThat(((List)map.get("var")).get(1), (Matcher)CoreMatchers.is((Object)"B"));
    }

    @Test
    public void shouldSupportPhpStyleUrlEncodedPostBodiesForAListOnly() throws Exception {
        UrlFormFormat format = new UrlFormFormat();
        Map map = format.readMap("var[]=A&var[]=B", new String[0]);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(((List)map.get("var")).get(0), (Matcher)CoreMatchers.is((Object)"A"));
        MatcherAssert.assertThat(((List)map.get("var")).get(1), (Matcher)CoreMatchers.is((Object)"B"));
    }

    @Test
    public void shouldSupportPhpStyleUrlEncodedPostBodiesForAListAndNonListParams() throws Exception {
        UrlFormFormat format = new UrlFormFormat();
        Map map = format.readMap("var[]=A&var[]=B&foo=bar", new String[0]);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(((List)map.get("var")).get(0), (Matcher)CoreMatchers.is((Object)"A"));
        MatcherAssert.assertThat(((List)map.get("var")).get(1), (Matcher)CoreMatchers.is((Object)"B"));
        Assert.assertEquals((Object)"bar", map.get("foo"));
    }
}

